import java.util.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.color.*;
import java.awt.image.BufferedImage;
/***********************
 * Questa applicazione consente di creare uno schema concettuale partendo da un file di testo 
 * contenente la descrizione dello schema fatta nel seguente modo:
 * 1) per ogni riga del file c'e' la descrizione di una entita' o di una relazione.
 * 2) Se la riga rappresenta una entita' si scrive il nome dell'entita' seguito da ':'
 *    seguito dai nomi delle proprieta' separati da ','.
 * 3) Se l'entita' e' un sottinsieme di un'altra entita' bisogna mettere prima del nome
 *    dell'entita' il nome del soprainsieme seguito da '<'.
 * 4) Se la riga rappresenta una associazione si scrive il nome della relazione seguito da '='
 *    e seguito dall'elenco delle entita' che sono in relazione tra loro separate
 *    da '#', eventualmente seguito da ':' e l'elenco delle proprieta' della relazione separate da ','.
 *      // Entità
 * Iscritto:CF,nome,cognome,password,indirizzo,iscrizione,sospeso,cancellato
 * Iscritto<Amministratore:ruolo
 * Quesito:testoQ,data,percentuale minima
 * Risposta:testoR
 * 
 *     // Associazioni
 * Vota=Iscritto#Risposta
 * Indice=Amministratore#Quesito
 * Partecipa=Iscritto#Quesito:presente
 * Ha=Risposta#Quesito
 * 5) Verranno colorate di blu le proprieta' delle entita' e le loro connessioni,
 *    di violetto le associazioni e le loro connessioni, di rosso spesse le connessioni IsA.
 * 6) i caratteri che seguono la coppia '//' vengono ignorati come commenti");
 *
 ***********************/
public class SchemaConcettuale extends JFrame
{
JMenu fileMenu;
JMenu modifyMenu;
JMenu helpMenu;
JMenuBar mb;

/**creo i bottoni del menu' con delle immagini**/
ImageIcon newsIc;
JMenuItem new_;
ImageIcon editIc;
JMenuItem edit;
ImageIcon openIc;
JMenuItem open;//apri
ImageIcon loadIc;
JMenuItem load;
ImageIcon saveIc;
JMenuItem save;
ImageIcon textIc;
JMenuItem text;
ImageIcon imageIc;
JMenuItem image;
ImageIcon priceIc;
JMenuItem price;//cerca il cammino con prezzo minimo
ImageIcon adaptIc;
JMenuItem adapt;
ImageIcon resetIc;
JMenuItem reset;
ImageIcon askIc;
JMenuItem ask;
ImageIcon guidaIc;
JMenuItem guida;

boolean interactive=false; //dialogo aperto(no)
String file="";
String schema=null;
GraphJPanel gp;
//PresPann pannello;
String NUOVO="Nuovo",
       EDITA="Edita",
       APRI="Apri",
       AGGIUNGI="Aggiungi",
       SALVAGRAFO="Salva grafo",
       SALVATESTO="Salva testo",
       SALVAIMMAGINE="Salva immagine",
       MINIMO="Prezzo minimo",
       ADATTA="Adatta",
       RESET="Reset",
       INFO="Info",
       GUIDA="Guida";


public SchemaConcettuale() throws Exception
  {
  this(null);
  }
public SchemaConcettuale(String f) throws Exception
  {
  /*****impostazione finestra principale*****/
  super("Schema Concettuale");
  int space=200;
  gp=new GraphJPanel();
  Toolkit toolKit = Toolkit.getDefaultToolkit();
  Dimension dimensioniSchermo = toolKit.getScreenSize();
//  setLocation((int) dimensioniSchermo.getWidth()/4, (int) dimensioniSchermo.getHeight()/4);
  setLocation(space/2,space/2);
  setSize((int) dimensioniSchermo.getWidth()-space, (int) dimensioniSchermo.getHeight()-space);
  getContentPane().setLayout(new GridLayout());
  getContentPane().add(gp);

  addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      setVisible(false);
      dispose();
      }
    });
  
  /**creo i bottoni del menu' con delle immagini**/
  String dir="icons/";
  newsIc = new ImageIcon(dir+"new.png");
  new_ = new JMenuItem(NUOVO, newsIc);
  editIc = new ImageIcon(dir+"edit.png");
  edit = new JMenuItem(EDITA, editIc);
  openIc = new ImageIcon(dir+"open.png");
  open = new JMenuItem(APRI, openIc);
  loadIc = new ImageIcon(dir+"add.png");
  load = new JMenuItem(AGGIUNGI, loadIc);//apri
  saveIc = new ImageIcon(dir+"save.png");
  save = new JMenuItem(SALVAGRAFO, saveIc);
  textIc = new ImageIcon(dir+"text.png");
  text = new JMenuItem(SALVATESTO, textIc);
  imageIc = new ImageIcon(dir+"image.png");
  image = new JMenuItem(SALVAIMMAGINE, imageIc);
  priceIc = new ImageIcon(dir+"price.png");
  price = new JMenuItem(MINIMO, priceIc);//cerca il cammino con prezzo minimo
  adaptIc = new ImageIcon(dir+"adapt.png");
  adapt = new JMenuItem(ADATTA, adaptIc);
  resetIc = new ImageIcon(dir+"reset.png");
  reset = new JMenuItem(RESET, resetIc);
  askIc = new ImageIcon(dir+"info.png");
  ask = new JMenuItem(INFO, askIc);
  guidaIc = new ImageIcon(dir+"guide.png");
  guida = new JMenuItem(GUIDA, guidaIc);

  /**creazione barra e inserimento dei menù**/
  mb = new JMenuBar();
  setJMenuBar(mb);
  /**creazione menù vuoti**/
  fileMenu = new JMenu("File");
  modifyMenu = new JMenu("Ricerca");
  helpMenu = new JMenu("?");
  /**inserimento voci del menù**/
  fileMenu.add(new_);
  fileMenu.add(edit);
  fileMenu.add(open);
  fileMenu.add(load);
  fileMenu.add(save);
  fileMenu.add(text);
  fileMenu.add(image);
  modifyMenu.add(price);
  modifyMenu.add(adapt);
  modifyMenu.add(reset);
  helpMenu.add(ask);
  helpMenu.add(guida);
  //mb.setBackground(Color.ORANGE);
  mb.add(fileMenu);
  mb.add(modifyMenu);
  mb.add(helpMenu);
  setVisible(true);

  
  interactive=false; //dialogo aperto(no)
  file=f;
//  pannello = new PresPann();

  
  
  //okay = new JButton("cerca");//bottone che cerca il cammino di prezzo minimo
  
  /**impostazione degli ActionListener**/
  ActionListener al = new ActionListener()
    {  
    public void actionPerformed(ActionEvent e)
      {
      String az=e.getActionCommand();
      if(az.equals(NUOVO))
        {
        file=null;
        schema="";
        gp.clear();
        }
       else if(az.equals(EDITA))
        {
        file=null;
        edit();
        }
       else if(az.equals(APRI))
        {
        file=null;
        schema="";
        gp.clear();
        load();
        }
       else if(az.equals(AGGIUNGI))
        {
        file=null;
        load();
        }
       else if(az.equals(MINIMO))
        {
        }
       else if(az.equals(SALVAGRAFO))
        {
        saveGraph(true,true);
        }
       else if(az.equals(SALVATESTO))
        {
        saveText();
        }
       else if(az.equals(SALVAIMMAGINE))
        {
        saveImage();
        }
       else if(az.equals(ADATTA))
        {
        gp.setAdaptive(!gp.isAdaptive());
//        System.out.println("adapt");
        }
       else if(az.equals(RESET))
        {
        gp.setAdaptive(false);
        gp.clear();
        Scanner sc=new Scanner(schema);
        scanER(sc);
        }
       else if(az.equals(INFO))
        {
        JOptionPane.showMessageDialog(null,"SchemaConcettuale\nAutori: Carlo Schenone && Alessio Pastorino");
        }
       else if(az.equals(GUIDA))
        {
        JOptionPane.showMessageDialog(null,"Info utilizzo\n"+
                                           " Questa applicazione consente di creare uno schema concettuale partendo da un file di testo  contenente la descrizione dello schema fatta nel seguente modo:\n"+
                                           " 1) per ogni riga del file c'e' la descrizione di una entita' o di una relazione.\n"+
                                           " 2) Se la riga rappresenta una entita' si scrive il nome dell'entita' seguito da ':'\n"+
                                           "    seguito dai nomi delle proprieta' separati da ','.\n"+
                                           " 3) Se l'entita' e' un sottinsieme di un'altra entita' bisogna mettere prima del nome\n"+
                                           "    dell'entita' il nome del soprainsieme seguito da '<'.\n"+
                                           " 4) Se la riga rappresenta una associazione si scrive il nome della relazione seguito da '='\n"+
                                           "    e seguito dall'elenco delle entita' che sono in relazione tra loro separate\n"+
                                           "    da '#', eventualmente seguito da ':' e l'elenco delle proprieta' della relazione separate da ','.\n"+
                                           "       // Entità\n"+
                                           "Iscritto:CF,nome,cognome,password,indirizzo,iscrizione,sospeso,cancellato\n"+
                                           "Iscritto<Amministratore:ruolo\n"+
                                           "Quesito:testoQ,data,percentuale minima\n"+
                                           "Risposta:testoR\n"+
                                           "\n"+
                                           "      // Associazioni\n"+
                                           "Vota=Iscritto#Risposta\n"+
                                           "Indice=Amministratore#Quesito\n"+
                                           "Partecipa=Iscritto#Quesito:presente\n"+
                                           "Ha=Risposta#Quesito\n"+
                                           " 5) Verranno colorate di blu le proprieta' delle entita' e le loro connessioni,\n"+
                                           "    di violetto le associazioni e le loro connessioni, di rosso spesse le connessioni IsA.\n"+
                                           " 6) i caratteri che seguono la coppia '//' vengono ignorati come commenti");
        }
      }//fine actionPerformed
    };//fine ActionListener
  new_.addActionListener(al);
  new_.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_N, ActionEvent.CTRL_MASK));//Ctrl-N
  edit.addActionListener(al);
  edit.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_E, ActionEvent.CTRL_MASK));//Ctrl-E
  open.addActionListener(al);
  open.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));//Ctrl-O
  load.addActionListener(al);
  load.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_L, ActionEvent.CTRL_MASK));//Ctrl-L
  save.addActionListener(al);
  save.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_S, ActionEvent.CTRL_MASK));//Ctrl-S
  text.addActionListener(al);
  text.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_T, ActionEvent.CTRL_MASK));//Ctrl-T
  image.addActionListener(al);
  image.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, ActionEvent.CTRL_MASK));//Ctrl-I
  price.addActionListener(al);
  price.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_P, ActionEvent.CTRL_MASK));//Ctrl-P
  adapt.addActionListener(al);
  adapt.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_A, ActionEvent.CTRL_MASK));//Ctrl-A
  reset.addActionListener(al);
  reset.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_R, ActionEvent.CTRL_MASK));//Ctrl-R
  ask.addActionListener(al);
  ask.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_I, ActionEvent.CTRL_MASK));//Ctrl-I
  guida.addActionListener(al);
  guida.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_H, ActionEvent.CTRL_MASK));//Ctrl-H
  GraphAdapter grAd=new GraphAdapter(){
    public void nodeSelected(GraphEvent ge)
      {
      NodeSign node=ge.getNode();
      System.out.println("Selezionato nodo "+node);
      NodeSign[] nodes=gp.getNodes();
      NodeSign minLontano=null;
      String path[]=null;
      double peso=0;
      int passi=0;
      for (int in=0;in<nodes.length;in++)
        {
        if (!node.equals(nodes[in]))
          {
          path=gp.g.minPricePath(node.getName(),nodes[in].getName());
          if (path!=null)
            {
            double costo=gp.g.minPathCost(path);
            int p=path.length;
            if (minLontano==null || passi<p || (costo<peso && passi==p))
              {
              minLontano=nodes[in];
              peso=costo;
              passi=p;
              }
            }
          }
//        System.out.println(nodes[in].getName()+">"+minLontano+" peso="+peso+" passi="+(passi-1));
        }
      if (minLontano!=null)
        {
        minLontano.setColor(Color.yellow);
        gp.drawPath(Color.yellow,path);
//        gp.repaint();
        }
      }
    };
  gp.addGraphListener(grAd);
  if (file!=null)
    load();
  gp.setShowWeights(false);
//  gp.setPopUp(false);
//  gp.setEdit(false);
//  gp.setMovable(true);
  }//fine GraphReader()
/********
 * to remember that a dialog box was open avoiding to use incorrectly the second click
 *********/
boolean openDialog=false;
/************
 * Salva un grafo
 * @param graph se <b>true</b> salva la forma estesa, altrimenti salva la forma compatta
 * @param as se <b>true</b> chiede il nuovo nome del file in cui salvare il grafo, altrimenti usa il nome del file di provenienza
 ************/
void saveGraph(boolean graph, boolean as)
  {
  String filename=null,dirname=null;
  String ext=(graph?".gph":".maa");
  if (as)
    {
    FileDialog filer1=new FileDialog(this);
    filer1.setMode(FileDialog.SAVE); // Use the SAVE version of the dialog.
    // Make the dialog visible as a modal dialog box.
//    filer1.setFile(filename+ext);
    filer1.setFile("*"+ext);
    filer1.setFilenameFilter(new FilenameFilter()
      {
      /**********
       * Filtra i files da presentare 
       * @param dir la cartella che viene visualizzata
       * @param name il nome del file indicato
       * @return ritorna <b>true</b> se il file indicato e' da presentare, <b>false</b> altrimenti
       **********/
      public boolean accept(File dir, String name)
          {
          return false;
          }
      });
//    filer1.setDirectory(dirname);
    openDialog=true;
    filer1.setVisible(true);
    // Upon return, getFile() will be null if user cancelled the dialog.
    if (filer1.getFile() != null)
      {
      // Non-null file property after return implies user
      // selected a file to open.
      filename=filer1.getFile();
      if (filename.lastIndexOf('.')>=0)
        filename=filename.substring(0,filename.lastIndexOf('.'));
      dirname=filer1.getDirectory();
      setTitle("Schema Concettuale - "+filename);
      }
//    setMenu(true);
    }
  try
    {
    FileWriter fr=new FileWriter(dirname+filename+ext);
    if (graph)
      {
      gp.save(fr);
      }
     else
      gp.g.saveMatrix(fr);
    fr.close();
    }
   catch (IOException ioe)
    {}
  }

/************
 * Salva l'immagine del grafo
 ************/ 
private void saveImage()
  {
  BufferedImage off_Image =  new BufferedImage(gp.getWidth(), gp.getHeight(),BufferedImage.TYPE_INT_ARGB);
  Graphics2D g2 = off_Image.createGraphics();
//  System.out.println("print "+gp+" "+getWidth()+" "+getHeight()+" "+g2);
  gp.print(g2);
  // Filer makes use of a java.awt.FileDialog, and so its
  // mode property uses the same values as those of FileDialog.
  FileDialog filer1=new FileDialog(this);
  filer1.setFile("*.png");
  filer1.setFilenameFilter(new FilenameFilter()
    {
    /**********
     * Filtra i files da presentare 
     * @param dir la cartella che viene visualizzata
     * @param name il nome del file indicato
     * @return ritorna <b>true</b> se il file indicato e' da presentare, <b>false</b> altrimenti
     **********/
    public boolean accept(File dir, String name)
        {
        return false;
        }
    });
  filer1.setMode(FileDialog.SAVE); // Use the SAVE version of the dialog.
  // Make the dialog visible as a modal dialog box.
  openDialog=true;
  filer1.setVisible(true);
  // Upon return, getFile() will be null if user cancelled the dialog.
  if (filer1.getFile() != null)
    {
    File[] filename=filer1.getFiles();
    if (filename.length>0)
      try
        {
        // retrieve image
        ImageIO.write(off_Image, "png", filename[0]);
        }
       catch (IOException e)
        {
        }
    }
  }

/************
 * Salva il testo dello schema
 ************/ 
private void saveText()
  {
  FileDialog filer1=new FileDialog(this);
  filer1.setFile("*.er");
  filer1.setFilenameFilter(new FilenameFilter()
    {
    /**********
     * Filtra i files da presentare 
     * @param dir la cartella che viene visualizzata
     * @param name il nome del file indicato
     * @return ritorna <b>true</b> se il file indicato e' da presentare, <b>false</b> altrimenti
     **********/
    public boolean accept(File dir, String name)
        {
        return false;
        }
    });
  filer1.setMode(FileDialog.SAVE); // Use the OPEN version of the dialog.
  // Make the dialog visible as a modal dialog box.
  openDialog=true;
  filer1.setVisible(true);
  // Upon return, getFile() will be null if user cancelled the dialog.
  if (filer1.getFile() != null)
    {
    File[] filename=filer1.getFiles();
    if (filename.length>0)
      try
        {
        PrintWriter out=new PrintWriter(filename[0]);
        out.print(schema);
        out.close();
        }
       catch (IOException e)
        {
        }
    }
  }

void load()
  {
  FileReader k=null;
  FileDialog fd=null;
  if(file==null)
    {
    fd = new FileDialog(this);
    fd.setFile("*.er");
    fd.setMode(FileDialog.LOAD);
    interactive = true;
    fd.setVisible(true);
    file=fd.getFile();
    }
  if(file!=null)
    {
    try
      {
      k = new FileReader(file);
      Scanner sc=new Scanner(k);
      scanER(sc);
      k.close();
      }
     catch(Exception exn)
      {
      System.err.println("Errore " +exn);
      exn.printStackTrace();
      }
    }
  }
void edit()
  {
  JFrame text=new JFrame("Inserisci il testo");
  final JTextArea t;
  if (schema!=null)
    t=new JTextArea(schema);
   else
    t=new JTextArea();
  JButton ok=new JButton("Ok");
  Container pane=text.getContentPane();
  text.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
  text.setPreferredSize(new Dimension(400,500));
  pane.setLayout(new BorderLayout());
  pane.add(new JScrollPane(t),BorderLayout.CENTER);
  pane.add(ok,BorderLayout.SOUTH);
  ok.addActionListener(new ActionListener()
                        {
                        @Override
                        public void actionPerformed(ActionEvent ae)
                          {
                          text.setVisible(false);
                          Scanner k=new Scanner(t.getText());
                          schema=t.getText();
                          gp.clear();
                          scanER(k);
                          text.dispose();
//                          t.setText("");
                          }
                        });
  text.pack();
  text.setVisible(true);
  }
public void scanER(Scanner sc1)
  {
  int coordinate=10;
  int hRel=400,hEnt=200,hIsA=100,wRel=100,wEnt=100,wIsA=100,dh=50,dw=100;
  schema="";
  for(int lin=0;sc1.hasNextLine();lin++)
    {
    int start=0;
    String line=sc1.nextLine();
    schema+=line+"\n";
//    System.out.println(lin+": " +line);
    String isA=null;
    String rel=null;
    String ent=null;
    int pos=0;
    if (line.trim().length()==0 || line.trim().startsWith("//"))
      {
//      System.out.println("trim=<"+line.trim()+"> "+line.trim().length()+" nextLine="+sc1.hasNextLine());
      continue;
      }
    if ((pos=line.indexOf("//",start))>=0)
      {
      line=line.substring(0,pos);
//      System.out.println("//line="+line);
      }
    if ((pos=line.indexOf("<",start))>=0)
      {
      isA=line.substring(start,pos);
      start=pos+1;;
//      System.out.println("IsA="+isA);
      }
    if ((pos=line.indexOf("=",start))>=0)
      {
      rel=line.substring(start,pos);
      start=pos+1;;
//      System.out.println("rel="+rel);
      gp.addNode(rel,wRel,hRel,new Color(0x7f007f),20,4);
      NodeSign e=gp.getNode(rel);
      wRel+=dw;
      for (;true;)
        {
        boolean last=false;
        if (start==line.length())
          break;
        if ((pos=line.indexOf("#",start))<0)
          {
          last=true;
          if ((pos=line.indexOf(":",start))<0)
            pos=line.length();
          }
        String relaz=line.substring(start,pos);
        start=pos+1;
//        System.out.println("relaz="+relaz);
        gp.addArc(rel,relaz,Color.magenta);
        gp.addArc(relaz,rel,Color.magenta,1,false,1.0); // arco di ritorno nascosto
        if (last)
          break;
        }
      for (int dx=0;start<line.length();dx+=25)
        {
        if (start==line.length())
          break;
        if ((pos=line.indexOf(",",start))<0)
          {
          pos=line.length();
          }
        String prop=line.substring(start,pos);
        start=pos+1;
 //       System.out.println("prop="+prop);
        gp.addNode(prop,e.getX()+dx,e.getY()+dh,new Color(0x00007f),10,NodeSign.CIRCLE);
        gp.addArc(rel,prop,Color.blue);
        gp.getArc(rel,prop).setPreferredLength(30);
        gp.addArc(prop,rel,Color.blue,1,false,1.0); // arco di ritorno nascosto
//            gp.getArc(prop,rel).setPreferredLength(10);
        }
      }
    if ((pos=line.indexOf(":",start))>=0)
      {
      ent=line.substring(start,pos);
      start=pos+1;
//      System.out.println("ent="+ent);
      if (isA!=null)
        {
        gp.addNode(ent,wIsA,hIsA,Color.black,30,NodeSign.SQUARE);
        wIsA+=dw;
        }
       else
        {
        gp.addNode(ent,wEnt,hEnt,Color.black,30,NodeSign.SQUARE);
        wEnt+=dw;
        }
      NodeSign e=gp.getNode(ent);
      if (isA!=null)
        {
        gp.addArc(ent,isA,Color.red,5,true,1.0);  // relazione IsA
        gp.addArc(isA,ent,Color.red,1,false,1.0); // arco di ritorno nascosto
        }
      for (int dx=0;true;dx+=40)
        {
        if (start==line.length())
          break;
        if ((pos=line.indexOf(",",start))<0)
          {
          pos=line.length();
          }
        String prop=line.substring(start,pos);
        start=pos+1;
//        System.out.println("prop="+prop);
        if (isA!=null)
          {
          gp.addNode(prop,e.getX()+dx,e.getY()-dh,Color.blue,10,NodeSign.CIRCLE);
          }
         else
          {
          gp.addNode(prop,e.getX()+dx,e.getY()+dh,Color.blue,10,NodeSign.CIRCLE);
          }
        gp.addArc(ent,prop,Color.blue);
//        System.out.println(""+gp);
//        System.out.println(""+gp.getArc(ent,prop));
        gp.getArc(ent,prop).setPreferredLength(50);
        gp.addArc(prop,ent,Color.blue,1,false,1.0); // arco di ritorno nascosto
        if (start>line.length())
          break;
        }
      }
    /**/
    }
  gp.repaint();
  }//fine load

public static void main(String args[]) throws Exception
  {
  if (args.length>0)
    new SchemaConcettuale(args[0]);
   else
    new SchemaConcettuale();
  }
class VisualizzaPrezzo extends JFrame
{
JFrame VisPrice;//finestra che visualizza il prezzo

/****componenti presenti nella finestra di calcolo****/
boolean change=false;
GraphJPanel gp;
String testoRis="Il percorso di prezzo minimo tra i nodi e' :  ";
String sp[];
String contenuto1;
String contenuto2;
String inserimento1,inserimento2;
//JPanel testi = new JPanel();
//JPanel bottoni = new JPanel();
JLabel lp1;
JLabel lp2;
JLabel lpRis;
JTextField txt1;
JTextField txt2;
JTextField ris;
JButton calc;
//JButton ok1 = new JButton("v1");
//JButton ok2 = new JButton("v2");


public VisualizzaPrezzo(GraphJPanel gp1)
  {
  super("Calcolo prezzo minimo");
  gp=gp1;
  lp1 = new JLabel("Inserire il nodo di partenza:");
  lp2 = new JLabel("Inserire il nodo di arrivo:");
  lpRis = new JLabel(testoRis);
  txt1 = new JTextField(10);
  txt2 = new JTextField(10);
  ris = new JTextField(10);
  calc = new JButton("Calcolo Percorso");
  setSize(300,300);
  setLocation(660,255);
  //setResizable(false);
  txt1.setHorizontalAlignment(JTextField.CENTER);
  txt2.setHorizontalAlignment(JTextField.CENTER);
  ris.setHorizontalAlignment(JTextField.CENTER);
  ris.setEnabled(false);
  //setLayout(new FlowLayout());
  setLayout(new GridLayout(7,1));
  add(lp1);
  add(txt1);//nome
  add(lp2);
  add(txt2);//nome
  add(calc);
  add(lpRis);
  add(ris);
  
  NodeSign nodi[]=gp1.getNodes();
  //bottoni.setLayout(new GridLayout(2,1));
  //bottoni.add(ok1);
  //bottoni.add(ok2);
  //add(testi);
  //add(bottoni, BorderLayout.EAST);
  if (nodi.length>0)
    txt1.setText(nodi[0].getName());
  if (nodi.length>1)
    txt2.setText(nodi[1].getName());
  change=false;
  setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
//  show();
  setVisible(true);

  
  ActionListener ascoltatore = new ActionListener()
    {
    public void actionPerformed(ActionEvent ae)
      {
      try
        {
        String s = ae.getActionCommand();
        if(s.equals("Calcolo Percorso"))			
          {
          contenuto1=txt1.getText();
          contenuto2=txt2.getText();
          if(!" ".equals(contenuto1) && !" ".equals(contenuto2))
            {
            sp=gp.g.minPricePath(contenuto1,contenuto2);
            if(sp!=null)
              {
              ris.setText("percorso:");
              for(int i=0; i<sp.length; i++)
                ris.setText(ris.getText()+sp[i]+"-");
              ris.setText(ris.getText()+" costo:"+gp.g.minPathCost(sp));
              gp.drawPath(Color.red,sp);
              }
             else
              ris.setText("nodi non connessi");
            }
          }
        }
       catch(Exception e){
         e.printStackTrace();
       }
      }
    };
  calc.addActionListener(ascoltatore);
  txt1.addActionListener(ascoltatore);
  txt2.addActionListener(ascoltatore);
  }//fine VisualizzaPrezzo()
}//fine classe VisualizzaPrezzo

}//fine classe principale

