import java.awt.event.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.util.jar.*;
import java.util.zip.*;
import java.net.*;


public class RunDir extends Frame implements ActionListener, Runnable, FilenameFilter
{
static final long serialVersionUID=2;
private MenuBar menu;
private Menu file,play,info;
protected MenuItem esci,nuovo,salva,rileggi,about;
protected MenuItem cerca,numero,games[];
static String launcher;
String dir;
String dirList[];
Vector <String>toRun;
Vector <String>toAvoid;

public RunDir()
  {
  this (".");
  }
public RunDir(String d)
  {
  super("Run directory");
  this.dir=d;
  addWindowListener(new WindowAdapter(){
      public void windowClosing(WindowEvent e)
        {
        if (proc!=null)
          proc.destroy();
        System.exit(0);
        }
      }
    );
  menu=new MenuBar();
  setMenuBar(menu);
  file=new Menu("File");
  play=new Menu("Play");
  info=new Menu("About...");
  nuovo=new MenuItem("New");
  nuovo.addActionListener(this);
  file.add(nuovo);
  salva=new MenuItem("Save");
  salva.addActionListener(this);
  file.add(salva);
  rileggi=new MenuItem("Reload");
  rileggi.addActionListener(this);
  file.add(rileggi);
  cerca=new MenuItem("Find");
  cerca.addActionListener(this);
  file.add(cerca);
  numero=new MenuItem("Number");
  numero.addActionListener(this);
  file.add(numero);
  esci=new MenuItem("Exit");
  esci.addActionListener(this);
  file.add(esci);
  rescan();
  about=new MenuItem("by Carlo Schenone schenonec@gmail.com");
  info.add(about);
  menu.add(file);
  menu.add(play);
  menu.add(info);
  pack();
  setSize(170,55);
  setVisible(true);
  setLocation(50,50);
  }
public void rescan()
  {
  File dirFile=new File(dir);
  String listFile="RunDir.txt";
  toRun=new Vector<String>();
  toAvoid=new Vector<String>();
  try
    {
    BufferedReader br=null;
    if (new File(dirFile,listFile).exists())
      br=new BufferedReader(new FileReader(new File(dirFile,listFile)));
     else
      {
      InputStream is=getClass().getResourceAsStream(listFile);
      if (is!=null)
        br=new BufferedReader(new InputStreamReader(is));
      }
      String linea;
    if (br!=null)
      {
      for (;(linea=br.readLine())!=null;)
        {
        if (!linea.trim().equals(""))
          {
          if (linea.charAt(0)!='-')
            toRun.add(linea);
           else
            toAvoid.add(linea.substring(1));
          }
        }
      br.close();
      }
    }
   catch (FileNotFoundException fnfe)
    {
    }
   catch (IOException fnfe)
    {
    }
  java.security.CodeSource src = getClass().getProtectionDomain().getCodeSource();
  if (src != null)
    {
    URL jar = src.getLocation();
//    System.out.println("Resource "+jar);
    try
      {
      ZipInputStream zip = new ZipInputStream(jar.openStream());
//      System.out.println("trying "+zip);
      while(true)
        {
        ZipEntry e = zip.getNextEntry();
        if (e == null)
          break;
        String pName = e.getName();
        if (accept(null,pName) && pName.endsWith(".class") && pName.indexOf("/")<0)
          {
          pName=pName.substring(0,pName.lastIndexOf(".class"));
          if (toAvoid.indexOf(pName)==-1 && toRun.indexOf(pName)<0)
            toRun.add(pName);
          }
        }
      }
     catch (IOException ioe)
      {
      System.out.println("Skipping "+jar);
      }
    }
   else
    {
    System.out.println("empty jar");
    }
  dirList=dirFile.list(this);
  for (int i=0;dirList!=null && i<dirList.length;i++)
    {
    String pName=dirList[i].substring(0,dirList[i].lastIndexOf(".class"));
    if (toAvoid.indexOf(pName)==-1 && toRun.indexOf(pName)<0)
      toRun.add(pName);
    }
  if (games!=null)
    play.removeAll();
  games=new MenuItem[toRun.size()];
  for (int i=0;i<games.length;i++)
    {
    games[i]=new MenuItem((i+1)+" "+toRun.elementAt(i));
    games[i].addActionListener(this);
    play.add(games[i]);
    }
  }
public boolean accept(File dir, String name)
  {
//  System.out.printf(name);
  if (name.endsWith(".class"))
    {
//    System.out.printf(" ends with .class and ");
    name=name.substring(0,name.lastIndexOf(".class"));
//    System.out.printf("%s is ",name);
    String sa[]=new String[0];
    try
      {
      Class.forName(name).getDeclaredMethod("main",sa.getClass());
      }
     catch (ClassNotFoundException cnfe)
      {
//      System.out.printf("not accepted (no class)\n");
      return false;
      }
     catch (NoSuchMethodException nsme)
      {
//      System.out.printf("not accepted (no method)\n");
      return false;
      }
//    System.out.printf("accepted\n");
    return true;
    }
   else
    {
//    System.out.printf(" doesn't ends with .class\n");
    return false;
    }
  }
static Process proc=null;
public void actionPerformed(ActionEvent ae)
  {
  if (esci==ae.getSource())
    {
    System.exit(0);
    }
   else if (rileggi==ae.getSource())
    {
    rescan();
    }
   else if (nuovo==ae.getSource())
    {
    }
   else if (salva==ae.getSource())
    {
    }
   else if (cerca==ae.getSource() || numero==ae.getSource())
    {
    String risp="";
    int n=-1;
    if (cerca==ae.getSource())
      {
      risp=javax.swing.JOptionPane.showInputDialog("classe da eseguire: ");
      for (int v=0;v<toRun.size();v++)
        {
        if (toRun.get(v).indexOf(risp)>=0)
          n=v;
        }
//      n=toRun.indexOf(risp);
      }
     else if (numero==ae.getSource())
      {
      risp=javax.swing.JOptionPane.showInputDialog("indice della classe da eseguire: ");
      try
        {
      n=Integer.parseInt(risp)-1;
      }
       catch (NumberFormatException nfe)
        {
        n=toRun.indexOf(risp);
        }
      }
    if (n>=0 && n<games.length)
      {
      prog=games[n].getActionCommand();
      System.out.println("<"+prog+">");
      StringTokenizer st=new StringTokenizer(prog);
      System.out.println("program n. "+st.nextToken());
      progName=st.nextToken();
      new Thread(this).start();
      }
     else
      {
      javax.swing.JOptionPane.showMessageDialog(null,"programma "+risp+" non esistente", "Errore", javax.swing.JOptionPane.ERROR_MESSAGE);
      }

    }
   else
    {
    for (int i=0;i<games.length;i++)
      {
      if (games[i]==ae.getSource())
        {
//        prog=ae.getActionCommand();
        prog=games[i].getActionCommand();
        System.out.println("<"+prog+">");
        StringTokenizer st=new StringTokenizer(prog);
        System.out.println("program n. "+st.nextToken());
        progName=st.nextToken();
        new Thread(this).start();
        }
      }
    }
  }
String prog=null;
String progName=null;
@SuppressWarnings({"rawtypes","unchecked"})
public void run()
  {
  try
    {
/*
    if (proc!=null)
      proc.destroy();
    prog="java BoardGame strategy="+progName+" "+prog.substring(prog.indexOf(progName)+progName.length())+" fields="+progName+".labs ";
    System.out.println("Executing "+prog);
    proc=Runtime.getRuntime().exec(prog);
    InputStream ies=proc.getErrorStream();
    BufferedReader ebr=new BufferedReader(new InputStreamReader(ies));
    String elinea;
    for (;(elinea=ebr.readLine())!=null;)
      System.out.println(elinea);
    InputStream is=proc.getInputStream();
    BufferedReader br=new BufferedReader(new InputStreamReader(is));
    String linea;
    for (;(linea=br.readLine())!=null;)
      System.out.println(linea);
*/
    Class progClass=Class.forName(progName);
    System.out.println("Executing prog "+prog);
    String argLine=prog.substring(prog.indexOf(progName)+progName.length());
    StringTokenizer line=new StringTokenizer(argLine);
    String argClass[]=new String[line.countTokens()];
    for (int il=0;line.hasMoreTokens();il++)
      argClass[il]=line.nextToken();
    progClass.getDeclaredMethod("main",argClass.getClass()).invoke(progClass,(Object)argClass);
    }
   catch (Exception exc)
    {
    javax.swing.JOptionPane.showMessageDialog(null, "Errore",""+exc, javax.swing.JOptionPane.ERROR_MESSAGE);
    exc.printStackTrace();
    }
  }
public static void main(String a[])
  {
  int i=0;
//  System.out.println("a.length="+a.length);
  if (a.length==0)
    new RunDir();
   else
    {
    for (;i<a.length;i++)
      {
      if (a[i].length()==0)
        new RunDir();
       else if (a[i].charAt(0)=='#')
        launcher=a[0].substring(1);
       else
        new RunDir(a[i]);
      }
    }
  }
}
