/*************
 * Un nodo di un grafo
 * 4/2/19 reso una classe generica
 * 9/2/19 associato un valore al nodo
 *************/
public class Node<T>
{
/*************
 * Il nome del nodo
 *************/
String name;
/*************
 * L'oggetto associato
 *************/
T val;
/*************
 * Crea un nuovo nodo 
 * @param name il nome del nodo rappresentato
 *************/
public Node(String name)
  {
  this(name,null);
  }
/*************
 * Crea un nuovo nodo 
 * @param name il nome del nodo rappresentato
 * @param val il valore del nodo rappresentato
 *************/
public Node(String name,T val)
  {
  this.name=name;
  this.val=val;
  }
/************
 * Ritorna il nome del nodo
 * @return il nome del nodo
 ************/
public String getName()
  {
  return name;
  }
/************
 * Ritorna il valore del nodo
 * @return il valore del nodo
 ************/
public T getValue()
  {
  return val;
  }
/************
 * Associa ul valore al nodo
 * @param val il valore del nodo
 ************/
public void setValue(T val)
  {
  this.val=val;
  }
/************
 * Ritorna la stringa che descrive il nodo
 * @return la descrizione del nodo
 ************/
public String toString()
  {
  if (val==null || val==this)
    return name;
   else
    return name+"("+val+")";
  }
/************
 * Confronta il nodo con un altro oggetto
 * @param n l'oggetto da confrontare
 * @return <b>true</b> se <b>n</b> rappresenta lo stesso nodo, <b>false</b> altrimenti
 ************/
public boolean equals(Object n)
  {
  if (n instanceof String && name.equals((String)n))
    return true;
   else if (n instanceof Node && (val==null || ((Node)n).val==null) &&  name.equals(((Node)n).name))
    return true;
   else if (n instanceof Node && val!=null && ((Node)n).val==null && val.equals(((Node)n).val))
    return true;
   else if (val!=null && (n==null && val.equals(((Node)n).val)))
    return true;
   else
    return false;
  }
}

