import java.util.*;
import java.io.*;
import javax.swing.*;
import java.awt.*;
import java.lang.*;

/**
 Il lavoro del labirinto deve ricevere come argomento del programma il nome di un file in cui sia rappresentato un labirinto
 in forma letterale tramite i caratteri "* eu"
 dove "*" è il muro, lo spazio " " è il possibile percorso, "e" è una entrata e  "u" una uscita.
 Per esempio un possibile labirinto potrebbe essere 
****************
*       **    **
*e  ******** ***
**  *   *      *
** ** * * *    *
*     *   *u   *
****************
 Il programma deve calcolare il percorso più veloce per raggiungere una uscita da una entrata.
 La soluzione va visualizzata in una finestra a se stante (in subordine a terminale) 
 e salvata su un file con lo stesso nome del file di partenza seguito da una x.
 Il percorso viene visualizzato tramite il carattere '.' come nel caso dell'esempio:
****************
*       **    **
*e. ******** ***
**. *...*...   *
**.**.*.*.*.   *
* ....*...*u   *
****************
 Volendo essere raffinati invece che il carattere '.' si possono usare i caratteri '-' e '|' per i tratti orizzontali e verticali e il carattere '+' per le curve ottenendo
****************
*       **    **
*e+ ******** ***
**| *+-+*+-+   *
**|**|*|*|*|   *
* +--+*+-+*u   *
****************
 La soluzione può essere anche visualizzata passo per passo ad intervalli di un secondo.
**/

public class LabGraph
{

JFrame fin;
JTextArea ta;
String lab[][],sol[][], nome;
final String MURO="*",STRADA=" ",ENTRATA="e",USCITA="u",PERCORSO=".";
int x=0,y=0,inizioX,inizioY,uscitaX,uscitaY,nPassiMax=-1,nPassi=0;
boolean exit=false,destra,sinistra,giu,su;
Vector <String> percorso=new Vector <String>();

/**
 * Legge una mappa e risolve il laborinto relativo
 * @param m il labirinto da risolvere
 **/
public LabGraph(String m)
  {
  nome=m;
  lab=leggiMappa(m);
  GraphJPanel g=grafo(lab);
  g.setEdit(false);
  g.setMovable(false);
  g.setSliding(false);
  showFrame(null,g,lab);
  String camm[]=g.getGraph().minLengthPath(inizioY+"-"+inizioX,uscitaY+"-"+uscitaX);
  if (camm!=null)
    {
    System.out.println("Cammino minimo di "+camm.length+" nodi");
    nPassiMax=camm.length-1;
    g.drawPath(Color.RED,camm);
    for (int n=1;n<camm.length;n++)
      {
      NodeSign from,to;
      from=g.getNode(camm[n-1]);
      to=g.getNode(camm[n]);
      to.setFilled(true);
      if (n<camm.length-1)
        to.setColor(Color.BLUE);
      g.getArc(from,to).setColor(Color.BLUE);
      g.repaint();
      Scanner in=new Scanner(camm[n]);
      in.useDelimiter("-");
      if (n<camm.length-1)
        {
        int i=in.nextInt(),j=in.nextInt();
        lab[i][j]=PERCORSO;
        }
      for (int i=0;i<lab.length;i++)
        {
        for (int j=0;j<lab[i].length;j++)
          System.out.print(lab[i][j]);
        System.out.println();
        }
      showFrame("PASSO "+n,g,lab);
      }
    try
      {
      PrintWriter pw=new PrintWriter(new FileWriter(m+"Sol.txt"));
      for (int i=0;i<lab.length;i++)
        {
        for (int j=0;j<lab[i].length;j++)
          pw.print(lab[i][j]);
        pw.println();
        }
      pw.close();
      }
     catch (IOException ioe)
      {
      }
    }
   else
    System.out.println("Cammino non trovato");
  System.out.println("finito");
  }
/**
 * Legge una mappa nel formato indicato sopra
 * @param mappa il nome del file contenente la mappa senza estenzione
 * @return la matrice contenente la mappa
 **/
public String [][] leggiMappa(String mappa)
  {
  int h,w=0;
  String lab[][]=null;
  try
    {
    BufferedReader br = new BufferedReader(new FileReader(mappa+".txt"));
    String riga="",riga1="";
    for(h=0;(riga=br.readLine())!=null;h++)  // conta le righe da leggere successivamente
      {
//      System.out.println(h+" "+riga);
      if (w<riga.length())
        w=riga.length();
      }
    lab=new String[h][w];
    br = new BufferedReader(new FileReader(mappa+".txt"));
    for(int i=0;i<lab.length;i++)  //inserisce la mappa letta nella matrice lab
      {
      riga=br.readLine();
      for(int j=0;j<riga.length();j++)
        lab[i][j]=riga.substring(j,j+1);
      }
    }
   catch (IOException ioe)
    {
    ioe.printStackTrace();
    }
  for(int i=0;i<lab.length;i++)  //trova le coordinate dell'entrata
    for(int j=0;j<lab[0].length;j++)
      {
      if(lab[i][j].equals(ENTRATA))
        {
        inizioX=j;
        inizioY=i;
        }
      if(lab[i][j].equals(USCITA))
        {
        uscitaX=j;
        uscitaY=i;
        }
      }
  return lab;
  }
/**
 * Crea una GraphPanel contenente la mappa del labirinto
 * @param lab il labirinto
 * @return il GraphPanel
 **/
public GraphJPanel grafo(String lab[][])
  {
  GraphJPanel nodi=new GraphJPanel();
  nodi.setShowText(false);
  for(int i=0;i<lab.length-1;i++)
    for(int j=0;j<lab[i].length;j++)
      {
      if(lab[i][j].equals(STRADA))
        nodi.addNode(i+"-"+j,j*20,i*30,Color.BLACK,10,NodeSign.SQUARE,false);
      if(lab[i][j].equals(ENTRATA))
        nodi.addNode(i+"-"+j,j*20,i*30,Color.GREEN,10,NodeSign.SQUARE,true);
      if(lab[i][j].equals(USCITA))
        nodi.addNode(i+"-"+j,j*20,i*30,Color.RED,10,NodeSign.SQUARE,true);
      }
  System.out.println("I NODI SONO: "+nodi.getGraph().degree());
  for(int r=0;r<lab.length;r++)
    {
    int d[]={0,0,1,-1};
    for(int c=0;c<lab[r].length;c++)
      if (lab[r][c].equals(STRADA) || lab[r][c].equals(ENTRATA) || lab[r][c].equals(USCITA))
        for (int p=0;p<4;p++)
          if (lab[r+d[p]][c+d[(p+2)%4]].equals(STRADA) || lab[r+d[p]][c+d[(p+2)%4]].equals(ENTRATA) || lab[r+d[p]][c+d[(p+2)%4]].equals(USCITA))
            nodi.addArc(r+"-"+c,(r+d[p])+"-"+(c+d[(p+2)%4]));
    }
  return nodi;
  }
/**
 * Ritorna una stringa contenente la visuallizzazione del labirinto
 * @param lab il labirinto
 * @return la stringa contenente il contenuto del labirinto
 **/
public String labConvert(String lab[][])
  {
  String labC="";
  for(int i=0;i<lab.length;i++)
    {
    for (int j=0;j<lab[i].length;j++)
      {
      char sym=' ';
      switch (lab[i][j])
        {
        case MURO:
          sym='*';
          break;
        case ENTRATA:
          sym='E';
          break;
        case USCITA:
          sym='U';
          break;
        case PERCORSO:
          sym='.';
          break;
        default:
          sym=' ';
        }
      labC+=sym;
      }
    labC+="\n";
		}
  return labC;
  }

/**
 * Presenta in una finestra il contenuto di un labirinto
 * @param testo il testo da premettere alla visualizzare
 * @param g il GraphJPanel in cui visualizzare il labirinto
 * @param lab il labirinto da visualizzare
 **/
public void showFrame(String testo,GraphJPanel g,String lab[][])
  {
  if(testo==null)
    {
    fin=new JFrame("Labirinto");
    fin.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    ta=new JTextArea(lab.length,lab[0].length);
    ta.setFont(new Font("Monospaced",1,15));
    ta.setEditable(false);
    JPanel pan=new JPanel();
    pan.add(ta);
    pan.add(g);
    fin.getContentPane().add(pan);
    fin.setVisible(true);
    fin.pack();
    ta.setText(labConvert(lab));
    }
   else
    {
    ta.setText(labConvert(lab));
    ta.append(testo+((nPassiMax<0)?"":" trovata soluzione in "+nPassiMax+" passi"));
    fin.pack();
    try 
      {
      Thread.sleep(100);                 
      }
     catch(InterruptedException ex) 
      {
      Thread.currentThread().interrupt();
      }
    }
  }
/**
 * Il programma principale che prende il nome del labirinto dagli argomenti, se ci sono, altrimenti apre una finestra di
 * selezione per il file da acquisire
 * @param args l'elenco dei nomi dei files dei labirinti di cui si vuole trovare la via d'uscita
 * @throws Exception se ci sono problemi nell'apertura dei files.
 **/
public static void main(String[]args)throws Exception
  {
  String dir="labGraph";
  String nome="mappa";
  if (args.length>1)
    nome=args[0];
   else
    {
    JFileChooser chooser = new JFileChooser(dir);
//    FileNameExtensionFilter filter = new FileNameExtensionFilter(
//        "JPG & GIF Images", "jpg", "gif");
//    chooser.setFileFilter(filter);
    int returnVal = chooser.showOpenDialog(null);
    if(returnVal == JFileChooser.APPROVE_OPTION)
      {
      nome=chooser.getSelectedFile().getName();
      nome=chooser.getCurrentDirectory()+"/"+nome.substring(0,nome.lastIndexOf("."));
      }
     else
      nome=JOptionPane.showInputDialog("File contenente il labirinto",nome);
    }
  new LabGraph(nome);
  }
}
