import java.io.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;
import java.lang.reflect.Method;

public class JGraphEditor extends JFrame
                          implements ActionListener,MouseListener
{
static final long serialVersionUID=1;
private static final String errMsg = "Error attempting to launch web browser";
int changeTheColors = 0;
int pass=0;
JButton buttonNew,buttonAdd,buttonRemove,buttonLink,buttonUnlink,buttonSepare,buttonSepare2,buttonSepare3,buttonSepare4;
JButton buttonOpen,buttonSave,buttonSaveMat,buttonColor,buttonPath,buttonInZoom,buttonOutZoom;
JToolBar toolbar;
boolean modified=false;
JFrame action,wind;
JTextField fileOrigine;
GraphJPanel gp;
JPanel inputZone;
JLabel status;
JTextField input;
JMenu mnFile,mnEdit,mnSearch,mnCol, mnHelp;
JMenuItem mnNew,mnSave,mnMat,mnOpen,mnExit,mnAdd,mnLink,mnRem,mnUnlink,mnMinL,mnMinP,mnPath,mnInfsu,mnGuide;
JMenuItem mnColRed,mnColBlack,mnColGreen,mnColBlue,mnColSpec,mnInternet;
Color activeColor=Color.black;
final static int COLOR=8;
String prompt[]={"",
                 "  Nome del nodo da aggiungere: ",
                 "  Da (nome nodo) a (nome nodo): ",
                 "  File da salvare: ",
                 "  File da aprire: ",
                 "  Nome dei nodi separati da uno spazio: ",
                 "  Nome dei nodi separati da uno spazio: ",
                 "  Scrivi il nome di tutti i nodi che vuoi collegare: ",
                 "  Rosso - Verde - Blu, codice esadecimale: ",
                 "  Nome: ",
                 "  Nome dei nodi separati da uno spazio: ",
                 "  Matrice da salvare: ",
                 };
int operation;
public JGraphEditor()
  {
  super(" *G R A P H   E D I T O R* ");
  wind=this;
  //setLocation(200,0);
  addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent e)
      {
      goExit();
      }
    });
	setLayout(new BorderLayout());
  gp=new GraphJPanel();
  //add(gp,BorderLayout.CENTER);
  gp.addMouseListener(this);
  inputZone=new JPanel(new GridLayout(2,2));
  status=new JLabel("",JLabel.RIGHT);
  input=new JTextField("",20);
  input.addActionListener(this);
  inputZone.add(status);
  inputZone.add(input);
	input.setVisible(false);  //
  //add(inputZone,BorderLayout.NORTH);
  JMenuBar mb=new JMenuBar();
  setJMenuBar(mb);
  mnFile=new JMenu("File");
  mb.add(mnFile);
  mnNew=new JMenuItem("Nuovo");
  mnNew.addActionListener(this);
  mnFile.add(mnNew);
  mnOpen=new JMenuItem("Apri");
  mnOpen.addActionListener(this);
  mnFile.add(mnOpen);
  mnSave=new JMenuItem("Salva con nome");
  mnSave.addActionListener(this);
  mnFile.add(mnSave);
  mnMat=new JMenuItem("Salva matrice");
  mnMat.addActionListener(this);
  mnFile.add(mnMat);
  mnExit=new JMenuItem("Esci");
  mnExit.addActionListener(this);
  mnFile.add(mnExit);
  mnEdit=new JMenu("Modifica");
  mb.add(mnEdit);
  mnAdd=new JMenuItem("Aggiungi nodo");
  mnAdd.addActionListener(this);
  mnEdit.add(mnAdd);
	mnRem=new JMenuItem("Elimina nodo");
  mnRem.addActionListener(this);
  mnEdit.add(mnRem);
  mnLink=new JMenuItem("Collega");
  mnLink.addActionListener(this);
  mnEdit.add(mnLink);
  mnUnlink=new JMenuItem("Scollega");
  mnUnlink.addActionListener(this);
  mnEdit.add(mnUnlink);
  mnCol=new JMenu("Colore");
  mnEdit.add(mnCol);
  mnColBlack=new JMenuItem("Nero");
  mnColBlack.addActionListener(this);
  mnCol.add(mnColBlack);
  mnColRed=new JMenuItem("Rosso");
  mnColRed.addActionListener(this);
  mnCol.add(mnColRed);
  mnColGreen=new JMenuItem("Verde");
  mnColGreen.addActionListener(this);
  mnCol.add(mnColGreen);
  mnColBlue=new JMenuItem("Blu");
  mnColBlue.addActionListener(this);
  mnCol.add(mnColBlue);
  mnPath=new JMenuItem("Percorso");
  mnPath.addActionListener(this);
  mnEdit.add(mnPath);
  mnSearch=new JMenu("Cerca");
  mb.add(mnSearch);
  mnMinP=new JMenuItem("Prezzo minimo");
  mnMinP.addActionListener(this);
  mnSearch.add(mnMinP);
  mnMinL=new JMenuItem("Lunghezza minima");
  mnMinL.addActionListener(this);
  mnSearch.add(mnMinL);
  mnHelp=new JMenu("?");
  mb.add(mnHelp);
  mnInfsu=new JMenuItem("Informazioni su...");
  mnInfsu.addActionListener(this);
	mnHelp.add(mnInfsu);
	mnGuide=new JMenuItem("Guida");
	mnGuide.addActionListener(this);
	mnHelp.add(mnGuide);
	mnInternet=new JMenuItem("sito programma");
  mnInternet.addActionListener(this);
	mnHelp.add(mnInternet);
	toolbar=new JToolBar();
  boolean b = toolbar.isFloatable();
	toolbar.setFloatable(false);
	toolbar.setBackground(Color.white);
	buttonNew = setButton("Nuovo","NuovoIcona","NuovoIconaPremuta","NuovoIconaSelezione");
	buttonOpen = setButton("Apri","ApriIcona","ApriIconaPremuta","ApriIconaSelezione");
	buttonSave = setButton("Salva con nome","SalvaIcona","SalvaIconaPremuta","SalvaIconaSelezione");
	buttonSaveMat = setButton("Salva matrice","SalvaMatriceIcona","SalvaMatriceIconaPremuta","SalvaMatriceIconaSelezione");
	buttonSepare = setSeparator();
	buttonAdd = setButton("Aggiungi nodo","NodoIcona","NodoIconaPremuta","NodoIconaSelezione");
	buttonRemove = setButton("Rimuovi nodo","EliminaNodoIcona","EliminaNodoIconaPremuta","EliminaNodoIconaSelezione");
	buttonLink = setButton("Aggiungi collegamento","AggiungiCollegamentoIcona","AggiungiCollegamentoIconaPremuta","AggiungiCollegamentoIconaSelezione");
	buttonUnlink = setButton("Rimuovi collegamento","EliminaCollegamentoIcona","EliminaCollegamentoIconaPremuta","EliminaCollegamentoIconaSelezione");
	buttonPath = setButton("Percorso","PercorsoIcona","PercorsoIconaPremuta","PercorsoIconaSelezione");
	buttonSepare2 = setSeparator();
	buttonInZoom = setButton("Zoom avanti","ZoomAvantiIcona","ZoomAvantiIconaPremuta","ZoomAvantiIconaSelezione");
	buttonOutZoom = setButton("Zoom indietro","ZoomIndietroIcona","ZoomIndietroIconaPremuta","ZoomIndietroIconaSelezione");
	buttonSepare3 = setSeparator();
	buttonColor = setButton("Modifica i colori del tuo Graph Editor","ColoriIcona","ColoriIconaPremuta","ColoriIconaSelezione");
	buttonSepare4 = setSeparator();
	toolbar.add(buttonNew);
	toolbar.add(buttonOpen);
	toolbar.add(buttonSave);
	toolbar.add(buttonSaveMat);
	toolbar.add(buttonSepare);
	toolbar.add(buttonAdd);
	toolbar.add(buttonRemove);
	toolbar.add(buttonLink);
	toolbar.add(buttonUnlink);
	toolbar.add(buttonPath);
  toolbar.add(buttonSepare3);
	toolbar.add(buttonInZoom);
	toolbar.add(buttonOutZoom);
	toolbar.add(buttonSepare2);
	toolbar.add(buttonColor);
//	toolbar.add(buttonSepare4);
	add(toolbar,BorderLayout.NORTH);
//	add(inputZone,BorderLayout.CENTER);
//	inputZone.setBackground(Color.lightGray);
	add(gp,BorderLayout.SOUTH);
	wind.pack();
  wind.setVisible(true);
	gp.setVisible(true);
	gp.setBackground(Color.white);
  setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
  }
  
JButton setButton(String tip,String normIm,String pressedIm,String selectIm)
  {
  JButton nb = new JButton();
	nb.setToolTipText(tip);
	nb.setText(" ");
	nb.setMargin(new Insets(15, 15,0,0));
	nb.setContentAreaFilled(false);
	nb.setBorder(null);
	nb.setFocusPainted(false);
	nb.setIcon(new ImageIcon(getClass().getResource("icons/"+normIm+".GIF")));
	nb.setPressedIcon(new ImageIcon(getClass().getResource("icons/"+pressedIm+".GIF")));
	nb.setRolloverIcon(new ImageIcon(getClass().getResource("icons/"+selectIm+".GIF")));
	nb.addActionListener(this);
  return nb;
  }

JButton setSeparator()
  {
  JButton nb = new JButton();
	nb.setText(null);
	nb.setMargin(new Insets(1, 1,0,0));
	nb.setContentAreaFilled(false);
	nb.setBorder(null);
	nb.setFocusPainted(false);
	nb.setIcon(new ImageIcon(getClass().getResource("icons/SeparaIcona.GIF")));
  return nb;
  }

public void goExit()
  {
  Object[] options = {"       Si       ", "       No       "};
  int n = JOptionPane.showOptionDialog(action, "\n  Sei sicuro di voler uscire?\n\n", "Esci...",JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, new ImageIcon(getClass().getResource("icons/Esci.GIF")), options,options[1]);
  if(n == JOptionPane.YES_OPTION)
    {
    if (modified || gp.isModified())
      {
      n = JOptionPane.showOptionDialog(action, "\n  Vuoi perdere le ultime modifiche?\n\n", "Esci...",JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE, new ImageIcon(getClass().getResource("icons/Esci.GIF")), options,options[1]);
      if (n == JOptionPane.YES_OPTION)
        {
        dispose();
        }
      }
     else
      {
      dispose();
      }
    }
  }

public void actionPerformed(ActionEvent ae)
  {
  StringTokenizer st=null;
  if (ae.getSource()==input)
    {
    String p[]= null;
    switch (operation)
			{
      case COLOR:
        try
          {
          activeColor=new Color(Integer.parseInt(input.getText().trim(),16));
          }
         catch (NumberFormatException nfe)
          {
          }
        break;
      }
    status.setText("");
    input.setText("");
    input.setEnabled(false);
    inputZone.validate();
    }
    if (ae.getSource()==mnNew||ae.getSource()==buttonNew)
			gp.clear();
	   else if (ae.getSource()==mnSave||ae.getSource()==buttonSave)
      {
			FileDialog fd = new FileDialog(wind,"Salva con nome",FileDialog.SAVE);
			fd.setVisible(true);
			String dir = fd.getDirectory();
			String file = fd.getFile();
			String fileName = dir + file+".txt";
			try
	      {
	      FileWriter fr=new FileWriter(fileName);
	      gp.save(fr);
				fr.close();
				}
	     catch (IOException ioe)
	      {
				}
			}
	   else if (ae.getSource()==mnMat||ae.getSource()==buttonSaveMat)
		  {
			FileDialog fd = new FileDialog(wind,"Salva matrice",FileDialog.SAVE);
			fd.setVisible(true);
			String dir = fd.getDirectory();
			String file = fd.getFile();
      if (file!=null)
        {
        String fileName = dir + file+((file.endsWith(".txt"))?"":".txt");
        try
          {
          FileWriter fr=new FileWriter(fileName);
          gp.g.saveMatrix(fr);
          fr.close();
          }
         catch (IOException ioe)
          {
          }
        }
      }
		else if (ae.getSource()==mnOpen||ae.getSource()==buttonOpen)
		  {
			FileDialog fd = new FileDialog(wind,"Apri",FileDialog.LOAD);
			fd.setVisible(true);
			String dir = fd.getDirectory();
			String file = fd.getFile();
      if (file!=null)
        {
        String fileName = dir+file;
        try
          {
          FileReader leggiFile = new FileReader(fileName);
          gp.load(leggiFile);
          leggiFile.close();
          }
         catch (IOException e)
          {
          }
        }
      }
	   else if (ae.getSource()==mnExit)
		  {
      goExit();
			}
	   else if (ae.getSource()==mnAdd||ae.getSource()==buttonAdd)
		  {
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome del nodo.");
			if(n==null)
				add(gp);
			 else
				gp.addNode(n,activeColor);
			}
	   else if (ae.getSource()==mnLink||ae.getSource()==buttonLink)
		  {
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome dei due nodi separati da uno spazio.");
			if(n==null)
				add(gp);
			 else
        {
  			st=new StringTokenizer(n);
				gp.addArc(st.nextToken(),st.nextToken(),activeColor);
			/*try
	      {
	      gp.addArc(st.nextToken(),st.nextToken(),activeColor,Float.parseFloat(st.nextToken()));
	      }
	     catch (NumberFormatException nfe)
	      {
	      }
*/
        }
			}
	   else if (ae.getSource()==mnRem||ae.getSource()==buttonRemove)
			{
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome del nodo.");
			if(n==null)
				add(gp);
			 else
			  gp.removeNode(n);
			}
	   else if (ae.getSource()==mnUnlink||ae.getSource()==buttonUnlink)
		  {
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome dei due nodi separati da uno spazio.");
			if(n==null)
				add(gp);
			 else
        {
  			st=new StringTokenizer(n);
	      gp.removeArc(st.nextToken(),st.nextToken());
        }
			}
	   else if (ae.getSource()==mnMinL)
		  {
			//StringTokenizer st=null;
			String p[]= null;
			p=null;
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome dei nodi separati da uno spazio.");
			st=new StringTokenizer(n);
			if(n==null)
				add(gp);
			 else
			  p=gp.g.minLengthPath(st.nextToken(),st.nextToken());
			}
		 else if (ae.getSource()==mnMinP)
		  {
			//StringTokenizer st=null;
			String p[]= null;
			p=null;
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome dei nodi separati da uno spazio.");
			if(n==null)
				add(gp);
			 else
        {
   			st=new StringTokenizer(n);
			  p=gp.g.minPricePath(st.nextToken(),st.nextToken());
        }
			}
	   else if (ae.getSource()==mnPath||ae.getSource()==buttonPath)
		  {
			String p[]= null;
			p=null;
			String n;
			n = JOptionPane.showInputDialog("Scrivi il nome dei nodi separati da uno spazio.");
	    if(n==null)
				add(gp);
			 else
        {
        st=new StringTokenizer(n);
        p=new String[st.countTokens()];
        for (int i=0;st.hasMoreTokens();i++)
          p[i]=st.nextToken();
			  gp.drawPath(activeColor,p);
        }
			}
	   else if (ae.getSource()==mnColRed)
	    activeColor=Color.red;
	   else if (ae.getSource()==mnColBlack)
	    activeColor=Color.black;
	   else if (ae.getSource()==mnColGreen)
	    activeColor=Color.green;
	   else if (ae.getSource()==mnColBlue)
	    activeColor=Color.blue;
	   else if (ae.getSource()==mnColSpec)
	    operation=startOperation(COLOR);
		 else if(ae.getSource()==mnInfsu)
			{
			JOptionPane.showMessageDialog(action, "             GRAPH EDITOR\n\nCreatori: Altamura Vanessa &\n                 Bruzzese Dario\n\nCol contributo di:\n      Prof. Carlo Schenone &\n      Prof. Livio Rimassa\n\nVersione definitiva 4 AI\n\nInformatico\nAldo Gastaldi                        JAVA\n                                                 2007", "Informazioni su...",JOptionPane.INFORMATION_MESSAGE,
			new ImageIcon(getClass().getResource("icons/Informazioni.GIF")));
			}
		 else if(ae.getSource()==mnGuide)
		  {
			JOptionPane.showMessageDialog(action, "Graph Editor  un editor col quale si possono disegnare grafi\n\nscegliendo nome dei nodi, costruendo archi,\n\n con i quali, a tua scelta, colleghi i vari nodi.\n\n I progetti si possono salvare; essi vengono\n\n salvati nella cartella predefinita di Graph Editor,\n\n solo in formato .txt. Puoi salvare anche le matrici che vengono\n\n costruite dai grafi, anch'esse in formato .txt.\n\n Il programma lavora grazie a Graph Panel.\n\n\n\n","Guida",JOptionPane.INFORMATION_MESSAGE,new ImageIcon(getClass().getResource("icons/Guida.GIF")));
			}
		 else if(ae.getSource()==buttonColor)
		  {
			if(ae.getModifiers()==InputEvent.BUTTON1_MASK)
				{
				switch(changeTheColors)
					{
					case 0:
						gp.setBackground(Color.lightGray);
						inputZone.setBackground(Color.white);
						changeTheColors = 1;
						break;
					case 1:
						gp.setBackground(Color.gray);
						changeTheColors = 2;
						break;
					case 2:
						gp.setBackground(Color.darkGray);
						changeTheColors = 3;
						break;
					case 3:
						gp.setBackground(Color.yellow);
						changeTheColors = 4;
						break;
					case 4:
						gp.setBackground(Color.orange);
						changeTheColors = 5;
						break;
					case 5:
						gp.setBackground(Color.red);
						changeTheColors = 6;
						break;
					case 6:
						gp.setBackground(Color.pink);
						changeTheColors = 7;
						break;
					case 7:
						gp.setBackground(Color.magenta);
						changeTheColors = 8;
						break;
					case 8:
						gp.setBackground(Color.cyan);
						changeTheColors = 9;
						break;
					case 9:
						gp.setBackground(Color.blue);
						changeTheColors = 10;
						break;
					case 10:
						gp.setBackground(Color.white);
						inputZone.setBackground(Color.lightGray);
						changeTheColors = 0;
						break;
					}
				}
			}
	   else if(ae.getSource()==mnInternet)
	    openURL("http://www.schenone.net/cs/GraphPanel");
		 else if (ae.getSource()==buttonInZoom)
			{
			gp.inZoom();
			add(gp,BorderLayout.SOUTH);
			}
		 else if(ae.getSource()==buttonOutZoom)
			{
			gp.outZoom();
			add(gp,BorderLayout.SOUTH);
			}
		}
private int startOperation(int op)
  {
  operation=op;
  status.setText(prompt[op]);
  input.setEnabled(true);
  inputZone.validate();
  return op;
  }
public void mouseClicked(MouseEvent e)
//           invocato quando il pulsante del mouse viene premuto e rilasciato nella stessa posizione
  {
	}
public void mouseEntered(MouseEvent e)
//           Invoked when the mouse enters a component.
  {
	gp.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
  }
public void mouseExited(MouseEvent e)
//           Invoked when the mouse exits a component.
  {
  }
public void mousePressed(MouseEvent e)
//        Invoked when a mouse button has been pressed on a component.
  {
  }
public void mouseReleased(MouseEvent e)
//           Invoked when a mouse button has been released on a component.
  {
  }
/*
public void setShortcut(MenuShortcut s)
  {	
  }
*/
public static void openURL(String url)
  {
  String osName = System.getProperty("os.name");
  try
    {
    if (osName.startsWith("Mac OS"))
      {
      Class fileMgr = Class.forName("com.apple.eio.FileManager");
      Method openURL = fileMgr.getDeclaredMethod("openURL",new Class[] {String.class});
      openURL.invoke(null, new Object[] {url});
      }
     else if (osName.startsWith("Windows"))
      Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
     else
      { //assume Unix or Linux
      String[] browsers = {"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape" };
      String browser = null;
      for (int count = 0; count < browsers.length && browser == null; count++)
         if (Runtime.getRuntime().exec(new String[] {"which", browsers[count]}).waitFor() == 0)browser = browsers[count];
      if (browser == null)
         throw new Exception("Could not find web browser");
      else
         Runtime.getRuntime().exec(new String[] {browser, url});
      }
    }
   catch (Exception e)
    {
    JOptionPane.showMessageDialog(null, errMsg + ":\n" + e.getLocalizedMessage());
    }
  }

public static void main(String a[])
  {
  try
		{
		//UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
   	//UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
		UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
 	  //SwingUtilities.updateComponentTreeUI(cf);
		}
	 catch(Exception ex)
		{
		}
  JGraphEditor ge=new JGraphEditor();
  ge.pack();
  ge.setVisible(true);
  }	
}
