/**
 * @(#)Italia.java
 *
 * Italia application
 *
 * @author Luca Gamberini
 * @version 1.00 2012/12/13
 */
 
import java.io.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import javax.swing.*;

 
public class Italia extends JFrame implements ActionListener,MouseListener
{
private Container c;
GraphJPanel it;
GraphEditor ge;
String NodoA, NodoB;
private JPanel p1,p;
private JButton cp,cv;
String OPTPERCORSO="Calcola percorso";
String OPTMOSTRA="Evidenzia citt";

public Italia()
 {
 super ("Gamberini");
 c =getContentPane();
 cp=new JButton(OPTPERCORSO);
 cp.addActionListener(this);
 cv=new JButton(OPTMOSTRA);
 cv.addActionListener(this);
 p=new JPanel ();
 p1=new JPanel ();
// ge=new GraphEditor();
 try
   {
   it=new GraphJPanel(new FileReader("italia/Italia.gph"));
   }
  catch(IOException fnfe)
   {
   fnfe.printStackTrace();
   }
 it.addMouseListener(this);
 p.setLayout (new BorderLayout());
 p1.add(cp);
 p1.add(cv);
 p.add("Center",it);
 p.add("South",p1);
 c.add(p);
 it.setShowNames(false);
 it.setSliding(false);
 it.setEdit(false);
 pack();
 setSize (900,900);
 setVisible(true);
 setResizable(true);
 setDefaultCloseOperation (JFrame.DISPOSE_ON_CLOSE);
 }
 
public void inputNodi()
  {
  NodoA = JOptionPane.showInputDialog("Citt di partenza");
  NodoB = JOptionPane.showInputDialog("Citt d'arrivo");
  if (NodoA==null || NodoB==null)
    JOptionPane.showMessageDialog(null,"Inserimento annullato");
   else
    {
    String citta="";
    String []nodi=it.g.minPricePath(NodoA,NodoB);
    it.drawPath(Color.green,nodi);
    it.drawPath(Color.green,it.g.minPricePath(NodoB,NodoA));
    for(int i=1;i<(nodi.length-1);i++)
      {
      NodeSign n=it.getNode(nodi[i]);
      n.setColor(Color.green);
      n.shape=1;
      n.filled=true;
      it.changeNode(nodi[i],n);
      if (i==1)
        citta=nodi[1];
       else
        citta=citta+","+nodi[i];
      }
//    JOptionPane.showMessageDialog(null,"citta visitate per raggiungere "+it.g.minPricePath(NodoA,NodoB)[it.g.minPricePath(NodoA,NodoB).length-1]+", partendo da "+it.g.minPricePath(NodoA,NodoB)[0]+": "+citta);
    if (nodi.length>2)
      JOptionPane.showMessageDialog(null,"con una distanza di "+it.g.costs(nodi)+"\nsi visitano "+(nodi.length-2)+" citta' per raggiungere "+nodi[nodi.length-1]+", partendo da "+nodi[0]+":\n"+citta);
     else
      JOptionPane.showMessageDialog(null,"con una distanza di "+it.g.costs(nodi)+"\nnon si visitano altre citta' per raggiungere "+nodi[nodi.length-1]+", partendo da "+nodi[0]);
    it.drawPath(Color.black,it.g.minPricePath(NodoA,NodoB));
    it.drawPath(Color.black,it.g.minPricePath(NodoB,NodoA));
    for(int i=1;i<(nodi.length-1);i++)
      {
      NodeSign n=it.getNode(nodi[i]);
      n.setColor(Color.black);
      n.shape=0;
      n.filled=false;
      it.changeNode(nodi[i],n);
      }
    }
  }

public void visitaCitta()
  {
  NodoA = JOptionPane.showInputDialog("Citt da evidenziare");
  if (NodoA==null)
    JOptionPane.showMessageDialog(null,"Inserimento annullato");
   else
    {
    NodeSign n=it.getNode(NodoA);
    if (n!=null)
      {
      n.setColor(Color.red);
      n.shape=1;
      n.filled=true;
      it.changeNode(NodoA,n);
      JOptionPane.showMessageDialog(null,"Nodo "+NodoA+" trovato in ("+n.getX()+","+n.getY()+")");
      n.setColor(Color.black);
      n.shape=0;
      n.filled=false;
      it.changeNode(NodoA,n);
      }
     else
      JOptionPane.showMessageDialog(null,"Nodo "+NodoA+" non trovato");
    }
  }
public void actionPerformed(ActionEvent e)
 {
 String txt = e.getActionCommand();
 if (txt.equals (OPTPERCORSO))
   inputNodi();
 if (txt.equals (OPTMOSTRA))
   visitaCitta();
 }
 
public void mouseClicked (MouseEvent e)
  {
//  System.out.println ("cliccato" + e);
  }
public void mouseExited (MouseEvent e)
  {
//  System.out.println ("uscito" + e);
  }
public void mousePressed (MouseEvent e)
  {
//  System.out.println ("pressato" + e);
  }
public void mouseReleased (MouseEvent e)
  {
//  System.out.println ("rilasciato" + e);
  }
public void mouseEntered (MouseEvent e)
  {
//  System.out.println ("entrato" + e);
  }
 
public static void main(String[] args)
  {
  new Italia();	
  }
}
