import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class InLista3 extends JFrame
{
class Elem
{
Object val;
Elem next;
}

GraphJPanel  gp;
Elem primo=null;
JLabel lab;
JTextField tf;
InLista3 inlista=this;
boolean daPanel=true,daProg=false,selNode=false,selArc=false;
public InLista3(Object a[])
  {
  super("InLista3");
  setLocation(100,100);
  tf=new JTextField();
  lab=new JLabel();
  gp=new GraphJPanel();
  gp.setShowWeights(false);
  getContentPane().setLayout(new BorderLayout());
  getContentPane().add(gp,BorderLayout.CENTER);
  getContentPane().add(tf,BorderLayout.SOUTH);
  getContentPane().add(lab,BorderLayout.NORTH);
  tf.addActionListener(new ActionListener()
                        {
                        public void actionPerformed(ActionEvent ae)
                          {
                          daPanel=false;
                          if (tf.getText().startsWith("-"))
                            removeSingleNode(tf.getText().substring(1));
                           else if (tf.getText().startsWith("#"))
                            shineNode(tf.getText().substring(1));
                           else
                            addSingleNode(tf.getText());
                          tf.setText("");
                          daPanel=true;
                          }
                        }
                      );
  gp.addGraphListener(new GraphAdapter()
                      {
                      public void nodeSelected(GraphEvent ge)
                        {
                        selNode=true;
                        }
                      public void arcSelected(GraphEvent ge)
                        {
                        selArc=true;
                        }
                      public void nodeAdded(GraphEvent ge)
                        {
                        if (daProg)
                          return;
                        if (daPanel && ge.getNode()!=null)
                          addSingleNode(ge.getNode().getName());
                        }
                      public void nodeRemoved(GraphEvent ge)
                        {
                        if (daPanel && ge.getNode()!=null)
                          removeSingleNode(ge.getNode().getName());
                        }
                      public void arcRemoved(GraphEvent ge)
                        {
                        if (daProg || selNode)
                          {
                          selNode=false;
                          selArc=false;
                          }
                         else if (daPanel && ge.getArc()!=null)
                          removeTail(ge.getArc().getTo().getName());
                        }
                      });
  pack();
  setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
  primo=faLista(a);
  showList(gp);
  setVisible(true);
  }

/**
 * ritorna la lista contenente gli elementi in arr
 * @param arr l'array di elementi da inserire in lista
 * @return la lista contenente gli elementi in arr
 */
public Elem faLista(Object arr[])
  {
  for (int i=0;i<arr.length;i++)
    {
    addSingleNode(""+arr[i]);
    }
  return primo;
  }
/**
 * Evidenzia nella lista un nodo
 * @param nome il nome del nodo da evidenziare in lista se  presente
 **/
public void shineNode(String nome)
  {
  NodeSign nodo=gp.getNode(nome);
  if (nodo!=null)
    {
    nodo.setSize(20);
    nodo.setFilled(true);
    }
  }
/**
 * Inserisce nella lista un nodo
 * @param nome il nome del nodo da inserire in lista se non  gi presente
 **/
public void addSingleNode(String nome)
  {
  Elem prec=null;
  for (Elem p=primo;p!=null;p=p.next)
    {
    if (p.val.equals(nome))
      return;
    prec=p;
    }
  Elem rif=new Elem();
  rif.val=nome;
  rif.next=null;
  if (prec==null)
    primo=rif;
   else
    prec.next=rif;
  showList(gp);
  }
/**
 * Rimuove dalla lista un nodo
 * @param nome il nome del nodo da rimuovere dalla lista se presente
 **/
public void removeSingleNode(String nome)
  {
  Elem prec=null,p;
  for (p=primo;p!=null && !p.val.equals(nome);p=p.next)
    prec=p;
  if (prec!=null)
    prec.next=(p!=null?p.next:null);
   else
    primo=(p!=null?p.next:null);
  showList(gp);
  }
/**
 * Rimuove dalla lista un nodo e tutti i suoi successivi
 * @param nome il nome del nodo da rimuovere coi successivi dalla lista se presente
 **/
public void removeTail(String nome)
  {
  Elem prec=null,p;
  for (p=primo;p!=null && !p.val.equals(nome);p=p.next)
    prec=p;
  if (prec!=null)
    prec.next=null;
   else
    primo=null;
  showList(gp);
  }
/**
 * Aggiorna il graphpanel con il contenuto della lista corrente
 * @param gp il GraphJPanel da aggiornare.
 **/
public void showList(GraphJPanel gp)
  {
  daProg=true;
  gp.clear();
  int inizio=50,spostamento=0,forma=0;
  Elem prec=null;
  for (Elem el=primo;el!=null;el=el.next,spostamento+=100,forma++)
    {
    gp.addNode(""+el.val,inizio+spostamento,100,Color.black,10,forma);
    if (prec!=null)
      {
      gp.addArc(""+prec.val,""+el.val);
      }
    prec=el;
    }
  setSize(new Dimension(spostamento+inizio,250));
  gp.setZoom(0);
  lab.setText(""+inlista);
  daProg=false;
  }
/**
 * Rappresenta in una stringa la lista corrente
 * @return la stringa  che rappresenta il contenuto della lista
 **/
public String toString()
  {
  String ris="{";
  for (Elem e=primo;e!=null;e=e.next)
    ris+=e.val+" ";
  return ris+"}";
  }
/**
 * Il programma principale dell'applicazione
 * @param s l'array di stringhe passate alla applicazione come argomenti
 **/
public static void main (String s[])
  {
  InLista3 il=new InLista3(s);
  }
}