import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import java.io.PrintWriter;
import java.io.FileWriter;
import java.io.IOException;

public class GraphSimulation extends Frame
  implements ActionListener
{
GraphJPanel gp;
TextField input;
boolean modified = false;
Frame wind;
JToolBar toolBar;
JButton mnAdd;
JButton mnLink;
JButton mnRem;
JButton mnUnlink;
JButton mnMinP;
JButton mnSito;
Color activeColor = Color.black;
int operation;
boolean simula = false;
List<String> lista;

public GraphSimulation()
  {
  super("GraphSimulation");
  wind = this;
  setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - 225, Toolkit.getDefaultToolkit().getScreenSize().height / 2 - 200);
  addWindowListener(new WindowAdapter()
            {
            public void windowClosing(WindowEvent we)
              {
              try
                {
                close();
                }
               catch (Exception e)
                {
                System.out.println("Errore nella chiusura");
                e.printStackTrace();
                }
              System.exit(0);
              }
            });
  setLayout(new BorderLayout());
  gp = new GraphJPanel();
  add(gp, "Center");
  toolBar = new JToolBar();
  mnAdd = new JButton(new ImageIcon(getClass().getResource("icons/aggiungi.png"), "Add node"));
  mnAdd.addActionListener(this);
  mnAdd.setToolTipText("Aggiungi un nodo");
  toolBar.add(mnAdd);
  mnLink = new JButton(new ImageIcon(getClass().getResource("icons/link.png"), "Link"));
  mnLink.addActionListener(this);
  mnLink.setToolTipText("Collega");
  toolBar.add(mnLink);
  mnRem = new JButton(new ImageIcon(getClass().getResource("icons/editdelete.png"), "Delete node"));
  mnRem.addActionListener(this);
  mnRem.setToolTipText("Elimina un nodo");
  toolBar.add(mnRem);
  mnUnlink = new JButton(new ImageIcon(getClass().getResource("icons/stop.png"), "Unlink"));
  mnUnlink.addActionListener(this);
  mnUnlink.setToolTipText("Scollega");
  toolBar.add(mnUnlink);
  mnMinP = new JButton(new ImageIcon(getClass().getResource("icons/minimo.png"), "Percorso"));
  mnMinP.addActionListener(this);
  mnMinP.setToolTipText("Calcola percorso");
  toolBar.add(mnMinP);
  mnSito = new JButton(new ImageIcon(getClass().getResource("icons/reload_all_tabs.png"), "Sito"));
  mnSito.addActionListener(this);
  mnSito.setToolTipText("Vai al sito");
  toolBar.add(mnSito);
  toolBar.setFloatable(false);
  add(toolBar, "North");
  lista = new ArrayList<String>(0);
  }

public void calcola()
  {
  Graph grp=gp.getGraph();
//  System.out.println("tutto il grafo:");
//  System.out.println(grp);
  for (int i = 0; i < lista.size(); ++i)
    {
    if (calcolaTab((String)lista.get(i)))
      ;
    }
  }

public boolean calcolaTab(String nome)
  {
  if (gp.findNode(nome) != -1)
    {
    try
      {
      File tab = new File("Tabelle");
      if (!(tab.exists()))
        {
        tab.mkdir();
        }
      PrintWriter pw = new PrintWriter(new FileWriter(new File("Tabelle/"+nome+".txt")));
//      System.out.println("Tabelle/"+nome+".txt");
      pw.println("Dest.\t|Next hop\t\t|Cost");
      NodeSign nodes[]=gp.getNodes();
      for (int i = 0; i < nodes.length; ++i)
        {
        if (!(nodes[i].getName().equals(nome)))
          { 
//          System.out.println(nome+">"+nodes[i].getName());
          String[] nuovo;
          if ((nuovo = gp.getGraph().minPath(nome, nodes[i].getName(), 0)) != null)
            {
//            System.out.println(nome+"-"+nodes[i].getName()+" "+(nuovo.length-1)+" passi");
            String bu = nodes[i].getName()+"\t|";
            if (nuovo.length == 2)
              bu+="direct";
             else
              for (int j=1; j<nuovo.length-1; j++)
                bu+=nuovo[j]+",";
            bu+="\t\t|"+gp.g.costs(nuovo);
            pw.println(bu);
            }
           else
            {
//            System.out.println(nome+"-"+nodes[i].getName()+" "+"non connessi");
            }
          }
        }
      pw.close();
      return true;
      }
     catch (IOException ioe)
      {
      ioe.printStackTrace();
      }
    }
  return false;
  }


public void close()
  {
  File nuovo;
  File[] lista;
  int i;
  try
    {
    nuovo = new File("Tabelle");
    lista = nuovo.listFiles();
    for (i = 0; i < lista.length; ++i)
      {
      lista[i].delete();
      }
    nuovo.delete();
    }
   catch (Exception eee)
    {
    }
  }

public void aggiungi(String n)
  {
  for (int i = 0; i < lista.size(); ++i)
    {
    if (n.equals(lista.get(i)))
      return;
    }
  lista.add(n);
  }

public void rimuovi(String n)
  {
  for (int i = 0; i < lista.size(); ++i)
    {
    if (n.equals(lista.get(i)))
      {
      lista.remove(i);
      }
    }
  new File("Tabelle/"+n+".txt").delete();
  }

public void actionPerformed(ActionEvent ae)
  {
  String input;
  String input1;
  if (ae.getSource() == mnAdd)
    {
    input = JOptionPane.showInputDialog(null, "Nome del nodo: ");
    if (input.length() > 0)
      {
      gp.addNode(input, activeColor);
      aggiungi(input);
      }
     else
      {
      JOptionPane.showMessageDialog(null, "Nome non valido!!", "Errore", 0);
      }
    }
   else if (ae.getSource() == mnLink)
    {
    input = JOptionPane.showInputDialog(null, "Nome del nodo di partenza: ");
    if (input.length() > 0)
      {
      aggiungi(input);
      input1 = JOptionPane.showInputDialog(null, "Nome del nodo di arrivo: ");
      if (input1.length() > 0)
        {
        aggiungi(input1);
        String input2 = JOptionPane.showInputDialog(null, "Prezzo dell'arco: ");
        if (input1.length() > 0)
          {
          try
            {
            float costo = Float.parseFloat(input2);
            gp.addArc(input, input1, activeColor, costo);
            }
           catch (NumberFormatException nfe)
            {
            JOptionPane.showMessageDialog(null, "il costo non  un numero corretto", "Errore", 0);
            }
          }
        }
      }
    }
   else if (ae.getSource() == mnRem)
    {
    input = JOptionPane.showInputDialog(null, "Nodo da eliminare: ");
    if (input.length() > 0)
      {
      gp.removeNode(input);
      rimuovi(input);
      }
    }
   else if (ae.getSource() == mnUnlink)
    {
    input = JOptionPane.showInputDialog(null, "Nome del nodo di partenza: ");
    if (input.length() > 0)
      {
      input1 = JOptionPane.showInputDialog(null, "Nome del nodo di arrivo: ");
      if (input1.length() > 0)
        {
        gp.removeArc(input, input1);
        }
      }
    }
   else if (ae.getSource() == mnMinP)
    {
    String[] p = null;
    input = JOptionPane.showInputDialog(null, "Nome del nodo di partenza: ");
    if (input.length() > 0)
      {
      input1 = JOptionPane.showInputDialog(null, "Nome del nodo di arrivo: ");
      if (input1.length() > 0)
        {
        p = gp.g.minPricePath(input, input1);
        if (p!=null)
          {
          String percorso="Il percorso e: ";
          String[] arr = p;
          for (int i = 0; i < arr.length; ++i)
            percorso+=arr[i]+",";
          percorso+=" e costa: "+gp.g.costs(p);
          JOptionPane.showMessageDialog(null, percorso);
          }
         else
          JOptionPane.showMessageDialog(null, "i nodi non sono connessi");
        }
      }
    }
   else if (ae.getSource() == mnSito)
    {
    openURL("http://www.schenone.net/cs/GraphPanel/");
    }
  calcola();
  }

public static void openURL(String url)
  {
  String osName = System.getProperty("os.name");
  try
    {
    if (osName.startsWith("Mac OS"))
      {
      Class fileMgr = Class.forName("com.apple.eio.FileManager");
      Method openURL = fileMgr.getDeclaredMethod("openURL", new Class[] { String.class });
      openURL.invoke(null, new Object[] { url });
      }
     else if (osName.startsWith("Windows"))
      {
      Runtime.getRuntime().exec(new StringBuilder().append("rundll32 url.dll,FileProtocolHandler ").append(url).toString());
      }
     else
      {
      String[] browsers = { "firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape" };
      String browser = null;
      for (int count = 0; (count < browsers.length) && (browser == null); ++count)
        if (Runtime.getRuntime().exec(new String[] { "which", browsers[count] }).waitFor() == 0)
          {
          browser = browsers[count];
          }
      if (browser == null)
        throw new Exception("Could not find web browser");
      Runtime.getRuntime().exec(new String[] { browser, url });
      }
    }
   catch (Exception e)
    {
    JOptionPane.showMessageDialog(null, e.getLocalizedMessage());
    }
  }

public static void main(String[] a)
  {
  GraphSimulation ge = new GraphSimulation();
  ge.setSize(400, 400);
  ge.setVisible(true);
  }
}