import java.awt.*;
import java.util.EventListener;
/**************
 * Un GraphListener viene invocato quando avvengono le principali azioni sul pannello
 **************/
public interface GraphListener extends EventListener
{
/***************
 * invocata quando un arco viene selezionato
 * @param ge il descrittore dell'evento
 ***************/
public void arcSelected(GraphEvent ge);
/***************
 * invocata quando un nodo viene selezionato
 * @param ge il descrittore dell'evento
 ***************/
public void nodeSelected(GraphEvent ge);
/***************
 * invocata quando un arco viene aggiunto
 * @param ge il descrittore dell'evento
 ***************/
public void arcAdded(GraphEvent ge);
/***************
 * invocata quando un nodo viene aggiunto
 * @param ge il descrittore dell'evento
 ***************/
public void nodeAdded(GraphEvent ge);
/***************
 * invocata quando un arco viene rimosso
 * @param ge il descrittore dell'evento
 ***************/
public void arcRemoved(GraphEvent ge);
/***************
 * invocata quando un nodo viene rimosso
 * @param ge il descrittore dell'evento
 ***************/
public void nodeRemoved(GraphEvent ge);
/***************
 * invocata quando viene fatto uno zoom sul pannello
 * @param ge il descrittore dell'evento
 ***************/
public void zoomed(GraphEvent ge);
/***************
 * invocata quando il pannello viene spostato
 * @param ge il descrittore dell'evento
 ***************/
public void moved(GraphEvent ge);
/***************
 * invocata quando il pannello viene modificato
 * @param ge il descrittore dell'evento
 ***************/
public void changed(GraphEvent ge);
/***************
 * invocata quando vengono modificati i default del pannello
 * @param ge il descrittore dell'evento
 ***************/
public void set(GraphEvent ge);
}