import java.awt.*;

public class GraphEvent extends AWTEvent
{
ArcSign a;
NodeSign n;
int zoomValue;
int xPos, yPos;
Color col;

/************
 * Crea un evento generico di cambiamento dell'arco
 * @param arc l'arco cambiato
 ************/
public GraphEvent(ArcSign arc)
  {
  super(arc,3006);
  a=arc;
  }
/************
 * Crea un evento generico di cambiamento del nodo
 * @param node il nodo cambiato
 ************/
public GraphEvent(NodeSign node)
  {
  super(node,3006);
  n=node;
  }
/************
 * Crea un evento di selezione di un arco
 * @param gp il pannello su cui  avvenuto il cambiamento
 * @param arc l'arco selezionato
 ************/
public GraphEvent(Object gp,ArcSign arc)
  {
  super(gp,3001);
  a=arc;
  }
/************
 * Crea un evento di selezione di un nodo
 * @param gp il pannello su cui  avvenuto il cambiamento
 * @param node il nodo selezionato
 ************/
public GraphEvent(Object gp,NodeSign node)
  {
  super(gp,3002);
  n=node;
  }
/************
 * Crea un evento di modifica dello zoom
 * @param gp il pannello su cui  avvenuto il cambiamento
 * @param zoom il valore di zoom selezionato selezionato
 ************/
public GraphEvent(Object gp,int zoom)
  {
  super(gp,3003);
  zoomValue=zoom;
  }
/************
 * Crea un evento di spostamento del grafo
 * @param gp il pannello su cui  avvenuto il cambiamento
 * @param x il valore dell'ascissa di spostamento
 * @param y il valore dell'ordinata di spostamento
 ************/
public GraphEvent(Object gp,int x,int y)
  {
  super(gp,3004);
  xPos=x;
  yPos=y;
  }
/************
 * Crea un evento di cambio del colore di sfondo del grafo
 * @param gp il pannello su cui  avvenuto il cambiamento
 * @param c il valore del nuovo colore del pannello
 ************/
public GraphEvent(Object gp,Color c)
  {
  super(gp,3005);
  col=c;
  }
/************
 * Crea un evento di cambiamento generico del grafo
 * @param gp il pannello su cui  avvenuto il cambiamento
 ************/
public GraphEvent(Object gp)
  {
  super(gp,3006);
  }

/************
 * Ritorna l'arco interessato all'evento
 * @return l'arco interessato
 ************/
public ArcSign getArc()
  {
  return a;
  }

/************
 * Ritorna il nodo interessato all'evento
 * @return il nodo interessato
 ************/
public NodeSign getNode()
  {
  return n;
  }

/************
 * Ritorna il valore di zoom conseguente all'evento
 * @return il valore di zoom
 ************/
public int getZoom()
  {
  return zoomValue;
  }

/************
 * Ritorna l'ascissa del punto interessato all'evento
 * @return l'ascissa del punto
 ************/
public int getX()
  {
  return xPos;
  }

/************
 * Ritorna l'ordinata del punto interessato all'evento
 * @return l'ordinata del punto
 ************/
public int getY()
  {
  return yPos;
  }

/************
 * Ritorna il punto interessato all'evento
 * @return il punto interessato
 ************/
public Point getPoint()
  {
  return new Point(xPos,yPos);
  }

/************
 * Ritorna il colore dello sfondo cambiato nell'evento
 * @return colore interessato
 ************/
public Color getColor()
  {
  return col;
  }
/************
 * Consuma l'evento (serve per passare da metodo protected a public)
 ************/
public void consume()
  {
  super.consume();
  }
/************
 * Ritorna la stringa che descrive l'evento
 * @return la stringa che descrive l'evento
 ************/
public String toString()
  {
  return "GraphEvent["+a+","+n+","+col+",("+xPos+","+yPos+"),"+zoomValue+"]";
  }
}
