import java.io.*;
import java.awt.*;
import java.util.*;
import java.text.*;
import java.awt.event.*;
import java.awt.image.*;
import javax.imageio.*;

import java.net.*;

/*****************
 * Un editor per grafi
 * @version 4.5
 *
 * 1/6/14
 *   inserito cambio di lingua nei menu e nelle richieste
 * 13/2/16
 *   corretta la memorizzazione dello spessore di default
 * 17/10/16
 *   corretto la modifica dello spessore degli archi
 *   attivato il funzionamento da server
 * 12/4/18
 *   corretto alcune voci del cambio di lingua del menu'
 * 23/4/18
 *   corretto l'inserimento dopo puntamento quando il pannello e' zoommato
 *   aggiunto il comportamento adattivo e la possibilit di fissare i nodi nell'adattamento e negli spostamenti multipli
 * 30/1/19
 *   corretto la ripresa del servizio come server
 * 4/2/19
 *   corretto i bordi bianchi della immagini salvate
 * 6/2/19
 *   corretto la chiusura del servizio come server alla chiusura della finestra
 *   corretto il primo aggiornamento della lingua
 * 12/2/19
 *   sistemato il default di fissaggio dei nodi
 * 27/5/19
 *   aggiunta la voce di men per la selezione/deselezione di tutti i nodi
 *****************/
public class GraphEditor extends Frame
                         implements ActionListener,MouseListener,MouseMotionListener,
                                    FilenameFilter,ImageReader,GraphListener,Runnable
{
static final long serialVersionUID=1;
/**********
 * la versione del programma
 **********/
String version="4.4";
/**********
 * il GraphPanel interno all'editor
 **********/
GraphPanel gp;
/**********
 * la zona di input
 **********/
Panel inputZone;
/**********
 * la barra di stato
 **********/
Label status;
/**********
 * il campo di suggerimento
 **********/
Label prompts;
/**********
 * indica se il grafo e' stato modificato
 **********/
boolean modified=false;
/**********
 * i nomi del file editato e della cartella che lo contiene 
 **********/
String filename="",dirname="";
/**********
 * le voci del menu' principale
 **********/
Menu mnFile,mnEdit,mnView,mnSearch,mnPoint,mnServe,mnHelp;
/**********
 * le voci dei menu' secondari
 **********/
Menu mnCol,mnDefault,mnZoom,mnLang,mnChange,mnSelect;
/**********
 * le sottovoci del menu'
 **********/
MenuItem mnNew,mnSave,mnMat,mnSaveAs,mnMatAs,mnSaveImage,mnOpen,mnMerge,mnPrint,mnExit;
MenuItem mnAdd,mnLink,mnRem,mnUnlink,mnImage,mnMinL,mnMinP,mnPath,mnRen,mnResize,mnReshape,mnSetFill,mnLinear,mnSetFix,mnSelAll,mnDeselAll,mnSelNode;
MenuItem mnAdd1,mnLink1,mnRem1,mnUnlink1,mnMinL1,mnMinP1,mnRen1,mnColSet1,mnResize1,mnWeight1,mnReshape1,mnSetFill1,mnImage1,mnThick1,mnVis1,mnSetFix1;
MenuItem mnColSet2,mnWeight2,mnResize2,mnReshape2,mnSetFill2,mnImage2,mnThick2,mnVis2,mnSetFix2;
MenuItem mnColRed,mnColBlack,mnColGreen,mnColBlue,mnColSpec,mnColPick,mnName,mnSize,mnWeight,mnShape,mnFill,mnThick,mnFix,mnLangs[];
MenuItem mnZoomIn,mnZoomOut,mnZoomSet;
MenuItem mnBackground,mnClearBackground;
MenuItem mnShowWeight,mnShowLabel,mnReset,mnAdapt;
MenuItem mnGuide,mnInfo;

MenuItem mnStart,mnStop;
Color activeColor=Color.black;
Image bg=null;
double defaultWeight=1.0;
String defaultName="node";
String defaultImage=null;
int defaultSize=10;
int defaultShape=NodeSign.CIRCLE;
int defaultThickness=0;
boolean defaultFill=false;
boolean defaultFixing=false;
final static int MFILE=0,MEDIT=1,MSERACH=2,MCOL=3,MZOOM=4;
final static int ADD=1,LINK=2,SAVE=3,OPEN=4,MINL=5,MINP=6,PATH=7,COLOR=8,REM=9,UNL=10,MAT=11,WEIGHT=12,SEC=13,
                 MINL1=14,MINP1=15,REN=16,REN1=17,ZOOM=18,NAME=19,BACKGROUND=20,CLICKONNODE=21,CLICKONARC=22,CLICKONSOME=23,LINK1=24,
                 SIZE=25,SIZE1=26,IMAGE=27,IMAGE1=28,ADD1=29,SHAPE=30,SHAPE1=31,FILL=32,FILL1=33,OK=34,WEIGHT1=35,
                 THICKA=36,THICKN=37,THICK=38,THICK1=39,VISIB=40,PORT=41,FIX=42,FIX1=43;

String promptText[][]={
                  {"English",
                   "name:",
                   "node node (price)",
                   "file to save:",
                   "file to open:",
                   "node node",  //5
                   "node node",
                   "node node ... node",
                   "RGB hex code:",
                   "name:",
                   "node node",  //10
                   "file to save:",
                   "weight of arcs:",
                   "node from ",
                   "first node",
                   "first node",  //15
                   "old new",
                   "new name for ",
                   "zoom (-2,7):",
                   "node name",
                   "image to load",  //20
                   "click on node",
                   "click on arc",
                   "click on node or arc",
                   "second node",
                   "node size",  //25
                   "new size for ",
                   "node image",
                   "new image for ",
                   "node position",
                   "node shape",  //30
                   "new shape for ",
                   "node filling",
                   "new filling for ",
                   "Ok",
                   "weight of the arc:",  //35
                   "arc thickness",
                   "node thickness of ",
                   "node or arc thickness",
                   "new thickness for ",
                   "visibility",  //40
                   "port number",
                   "node fixing",
                   "new fixing for ",
                   },
                   {
                   "Italiano",
                   "nome:",
                   "nodo nodo (prezzo)",
                   "file da salvare:",
                   "file da aprire:",
                   "nodo nodo",  //5
                   "nodo nodo",
                   "nodo nodo ... nodo",
                   "codice hex RGB:",
                   "nome:",
                   "nodo nodo",  //10
                   "file da salvare:",
                   "peso degli archi:",
                   "nodo da ",
                   "primo nodo",
                   "primo nodo",  //15
                   "vecchio nuovo",
                   "nuovo nome per ",
                   "zoom (-2,7):",
                   "nodo nome",
                   "immagine:",  //20
                   "click sul nodo",
                   "click sull'arco",
                   "click su nodo o arco",
                   "secondo nodo",
                   "node dimensione",  //25
                   "nuova dimensione per ",
                   "nodo immagine",
                   "nuova immagine per ",
                   "posizione nodo",
                   "nodo forma",  //30
                   "nuova forma per ",
                   "nodo riempimento",
                   "nuovo riempimento per ",
                   "Si",
                   "peso dell'arco:",  //35
                   "spessore dell'arco",
                   "spessore del nodo",
                   "spessore del nodo o arco",
                   "nuovo spessore per ",
                   "visibile",  //40
                   "numero della porta",
                   "nodo fissaggio",
                   "nuovo fissaggio per ",
                  },
                };
String prompt[]=promptText[0];
final int SCIRCLE=1,SSQUARE=2,SCROSS=3,PSHAPE=4,PFILL=5,STRUE=6,SFALSE=7,SYES=8,SNO=9,SVERSION=10,SNAME=11,SWEIGHT=12,
          SSIZE=13,SFILL=14,SSHAPE=15,STHICK=16,SVISIB=17,SFIX=18,PFIX=19;
String strings[][]=
                {
                  {
                  "",
                  "circle",
                  "square",
                  "cross",
                  "shape:",
                  "fill:",  //5
                  "true",
                  "false",
                  "yes",
                  "no",
                  "version", //10
                  "name",
                  "weight",
                  "size",
                  "fill",
                  "shape",  //15
                  "thickness",
                  "visibility",
                  "fixing",
                  "fixing:",
                  },
                  {
                  "",
                  "cerchio",
                  "quadrato",
                  "croce",
                  "forma:",
                  "riempimento:",
                  "vero",
                  "falso",
                  "si",
                  "no",
                  "versione",
                  "nome",
                  "peso",
                  "dim",
                  "riempi",
                  "forma",
                  "spessore",
                  "visibilita'",
                  "fissaggio:",
                  "fissato",
                  },
                };
String words[]=strings[0];
String warnMessageText[][]=
                {
                  {
                  "lose changes",
                  "cancel"
                  },
                  {
                  "perdi modifiche",
                  "annulla"
                  },
                };
String warnMessage[]=warnMessageText[0];
final int MNFILE=0,MNNEW=1,MNOPEN=2,MNMERGE=3,MNSAVE=4,MNSAVEAS=5,MNMAT=6,MNMATAS=7,MNSAVEIMG=8,MNCHANGEBG=9,MNCLEARBG=10;
final int MNPRINT=11,MNEXIT=12,MNEDIT=13,MNADDNODE=14,MNRENNODE=15,MNLINK=16,MNDELNODE=17,MNRESIZE=18,MNRESHAPE=19,MNFILL=20;
final int MNNEWIMG=21,MNUNLINK=22,MNSETDEF=23,MNDEFNAME=24,MNDEFWEI=25,MNDEFCOL=26,MNBLACK=27,MNRED=28,MNGREEN=29,MNBLUE=30;
final int MNSPEC=31,MNPICK=32,MNPATH=33,MNVIEW=34,MNZOOM=35,MNZOOMIN=36,MNZOOMOUT=37,MNZOOMSET=38,MNHIDEWEI=39,MNHIDELABS=40;
final int MNRESET=41,MNSEARCH=42,MNMINP=43,MNMINL=44,MNPOINT=45,MNPADD=46,MNPREN=47,MNPCOL=48,MNPWEI=49,MNPLINK=50;
final int MNPDEL=51,MNPRESIZE=52,MNPRESHAPE=53,MNPFILL=54,MNPIMG=55,MNPUNLINK=56,MNPMINP=57,MNPMINL=58,MNQM=59,MNABOUT=60;
final int MNSHOWWEI=61,MNSHOWLABS=62,MNDEFSHAPE=63,MNDEFFILL=64,MNDEFLANG=65,MNCHANGE=66,MNSIZE=67,MNMATRIX=68;
final int MNDEFTHICK=69,MNTHICK=70,MNVIS=71,MNGUIDE=72,MNLINEAR=73,MNSERVE=74,MNSTART=75,MNSTOP=76;
final int MNADAPT=77,MNFREEZE=78,MNDEFFIX=79,MNPFIX=80,MNFIX=81,MNSEL=82,MNSELALL=83,MNDESELALL=84,MNSELNODE=85;
String labels[][]=   // le etichette dei menu
                {
                  {
                  "File",
                  "New",
                  "Open",
                  "Merge",
                  "Save",
                  "Save as ...", //5
                  "Save matrix",
                  "Save matrix as ...",
                  "Save image as ...",
                  "Change background",
                  "Clear background", //10
                  "Print",
                  "Exit",
                  "Edit",
                  "Add node",
                  "Rename node", //15
                  "Link",
                  "Delete node",
                  "Resize node",
                  "Reshape node",
                  "Fill node", //20
                  "Node image",
                  "Unlink",
                  "Default",
                  "Name",
                  "Weight", //25
                  "Color",
                  "Black",
                  "Red",
                  "Green",
                  "Blue", //30
                  "Special",
                  "Pick",
                  "Path",
                  "View",
                  "Zoom", //35
                  "Zoom in",
                  "Zoom out",
                  "Zoom set",
                  "Hide weights",
                  "Hide labels", //40
                  "Reset",
                  "Search",
                  "Min price",
                  "Min length",
                  "Pointing", //45
                  "Add node",
                  "Rename node",
                  "Node/arc color",
                  "Arc weight",
                  "Link", //50
                  "Delete node",
                  "Node size",
                  "Node shape",
                  "Node filling",
                  "Node image", //55
                  "Unlink",
                  "Min price",
                  "Min length",
                  "?",
                  "About", //60
                  "Show weights",
                  "Show labels",
                  "Shape",
                  "Filling",
                  "Language", //65
                  "Change",
                  "Size",
                  "Matrix",   // Unused
                  "Thickness",
                  "Node/arc thickness",  //70
                  "Node/arc view",
                  "Guide",
                  "Linearise",
                  "Serve",
                  "Start",  //75
                  "Stop",
                  "Adapt",
                  "Freeze",
                  "Fixing",
                  "Node fixing",  //80
                  "Fix node",
                  "Select",
                  "Select all",
                  "Deselect all",
                  "Deselect/Select node",  // 85
                  },
                  {
                  "File",
                  "Nuovo",
                  "Apri",
                  "Unisci",
                  "Salva",
                  "Salva come ...",
                  "Salva matrice",
                  "Salva matrice come ...",
                  "Salva immagine come ...",
                  "Cambia sfondo",
                  "Elimina sfondo",
                  "Stampa",
                  "Esci",
                  "Modifica",
                  "Nuovo nodo",
                  "Rinomina nodo",
                  "Collega",
                  "Cancella nodo",
                  "Ridimensiona nodo",
                  "Forma nodo",
                  "Riempimento nodo",
                  "Immagine nodo",
                  "Scollega",
                  "Default",
                  "Nome",
                  "Peso",
                  "Colore",
                  "Nero",
                  "Rosso",
                  "Verde",
                  "Blu",
                  "Speciale",
                  "Scegli",
                  "Percorso",
                  "Vista",
                  "Zoom",
                  "Piu' grande",
                  "Piu' piccolo",
                  "Valore",
                  "Nascondi pesi",
                  "Nascondi etichette",
                  "Ripristina",
                  "Cerca",
                  "Min prezzo",
                  "Min lunghezza",
                  "Puntamento",
                  "Aggiungi nodo",
                  "Renomina nodo",
                  "Colore nodo/arco",
                  "Peso arco",
                  "Collega",
                  "Cancella nodo",
                  "Dimensione nodo",
                  "Forma nodo",
                  "Riempimento nodo",
                  "Immagine nodo",
                  "Scollega",
                  "Min prezzo",
                  "Min lunghezza",
                  "?",
                  "Informazioni",
                  "Mostra pesi",
                  "Mostra etichette",
                  "Forma",
                  "Riempimento",
                  "Lingua",
                  "Cambia",
                  "Dimensione",
                  "Matrice",  // Unused
                  "Spessore",
                  "Spessore nodo/arco",
                  "Vista nodo/arco",
                  "Guida",
                  "Linearizza",
                  "Servi",
                  "Inizia",  //75
                  "Ferma",
                  "Adatta",
                  "Frizza",
                  "Fissaggio",
                  "Fissaggio nodo",  //80
                  "Fissa nodo",
                  "Selezione",
                  "Seleziona tutti",
                  "Deseleziona tutti",
                  "Deseleziona/Seleziona nodo",
                  }
                 };
String label[]=labels[0];
String voices[][]=   // le voci per il menu di popup
                {
                  {
                  "English",
                  "Delete node",
                  "Delete arc",
                  "Min price -> other node",
                  "Min length -> other node",
                  "Change name",
                  "Change color",
                  "Change weight",
                  "Change zoom",
                  "Change size",
                  "Change image",
                  "Change shape",
                  "Change filling",
                  "Change thickness",
                  "Change fixing",
                  "Get info",
                  },
                  {
                  "Italiano",
                  "Cancella nodo",
                  "Cancella arco",
                  "Min prezzo -> altro nodo",
                  "Min lunghezza -> altro nodo",
                  "Cambia nome",
                  "Cambia colore",
                  "Cambia peso",
                  "Cambia zoom",
                  "Cambia dimensione",
                  "Cambia immagine",
                  "Cambia forma",
                  "Cambia riempimento",
                  "Cambia spessore",
                  "Cambia fissaggio",
                  "Informazioni",
                  },
                };
String promptPU[][]=
                {
                  {
                  "English",
                  "weight of arcs:",
                  "new name",
                  "node name:",
                  "zoom (-2..7):",
                  "choose a color",
                  "new size",
                  "new image",
                  "new shape",
                  "set filling",
                  "new thickness",
                  "new thickness of the arc:",
                  "circle",
                  "square",
                  "cross",
                  "no",
                  "yes",
                  "false",
                  "true",
                  "for",
                  "set fixing",
                  "node information",
                  },
                  {
                  "Italiano",
                  "peso dell'arco:",
                  "nuovo nome",
                  "nome nodo:",
                  "zoom (-2..7):",
                  "scegli colore",
                  "nuova dimensione",
                  "nuova immagine",
                  "nuova forma",
                  "scegli riempimento",
                  "nuovo spessore",
                  "nuovo spessore dell'arco:",
                  "cerchio",
                  "quadrato",
                  "croce",
                  "no",
                  "si",
                  "falso",
                  "vero",
                  "per",
                  "fissa",
                  "informazioni",
                  },
                };
String guides[]=
          {
          "You can creata a node with a click.\n"+
          "You can have a popup menu pressing the right button.\n"+
          "You can drag single nodes or you can slide the graph with the left button.\n"+
          "You can create connections or zoom the graph dragging with the right button.\n"+
          "You can select multiple nodes pressing or dragging with the shift key hold\n"+
          "It's possible to connect to the application like a server (default port 7823)\n"+
          "to obtain some information about the graph",
          "Puoi creare un nodo con un click.\n"+
          "Puoi far apparire un menu contestuale premendo il bottone destro\n"+
          "Puoi trascinare un singolo nodo o far scivolare il grafo con il bottone sinistro\n"+
          "Puoi creare delle connessioni o zoommare il grafo trascinando il bottone destro\n"+
          "Puoi selezionare piu' nodi schiacciando o trascinando col tasto MAIUSCOLO premuto\n"+
          "E' possibile connettersi all'applicazione come server (porta di default 7823)\n"+
          "per ottenere alcune informazioni sul grafo",
          };
String guide=guides[0];

String appInfo="GraphEditor\nCarlo Schenone\ncarlo@schenone.net";
int operation;
MouseEvent lastEvent;

/**********
 * Prepara un MenuItem
 * @param s l'etichetta della voce del menu
 * @param menu il menu a cui la voce va aggiunta
 * @return il MenuItem
 **********/
private MenuItem newMenuItem(String s,Menu menu)
  {
  MenuItem menuItem=new MenuItem(s);
  menuItem.addActionListener(this);
  menu.add(menuItem);
  return menuItem;
  }

/**********
 * Prepara un MenuItem
 * @param nl numero dell'etichetta della voce del menu
 * @param menu il menu a cui la voce va aggiunta
 * @return il MenuItem
 **********/
private MenuItem newMenuItem(int nl,Menu menu)
  {
  return newMenuItem(label[nl],menu);
  }

/**********
 * Prepara un Menu
 * @param nl numero dell'etichetta della voce del menu
 * @return il Menu
 **********/
private Menu newMenu(int nl)
  {
  Menu submenu=new Menu(label[nl]);
  return submenu;
  }

/**********
 * Crea un GraphEditor
 **********/
public GraphEditor()
  {
  super("Graph Editor");

  addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent e)
      {
      if (canChange())
        {
        gp.close();
        if (ss!=null && server!=null)
          try
            {
            ss.close();
            ss=null;
            for (ClientManager climan:cv)
              climan.interrupt();
            cv=null;
            server.interrupt();
            server=null;
            }
           catch (IOException ioe)
            {}
        setVisible(false);
        dispose();
        }
      }
    });
  setLayout(new BorderLayout());
  gp=new GraphPanel();
  add(gp,BorderLayout.CENTER);
  gp.removeMouseListener(gp);
  gp.addMouseListener(this);
  gp.addMouseListener(gp);
  gp.removeMouseMotionListener(gp);
  gp.addMouseMotionListener(this);
  gp.addMouseMotionListener(gp);
  gp.setImageReader(this);
  inputZone=new Panel(new GridLayout(1,2));
  status=new Label("         ",Label.LEFT);

  inputZone.add(status);
  prompts=new Label("         ",Label.LEFT);
  inputZone.add(prompts);
  add(inputZone,BorderLayout.SOUTH);
  MenuBar mb=new MenuBar();
  setMenuBar(mb);
  mnFile=newMenu(MNFILE);
  mb.add(mnFile);
  mnNew=newMenuItem(MNNEW,mnFile);
  mnOpen=newMenuItem(MNOPEN,mnFile);
  mnMerge=newMenuItem(MNMERGE,mnFile);
  mnSave=newMenuItem(MNSAVE,mnFile);
  mnSaveAs=newMenuItem(MNSAVEAS,mnFile);
  mnMat=newMenuItem(MNMAT,mnFile);
  mnMatAs=newMenuItem(MNMATAS,mnFile);
  mnSaveImage=newMenuItem(MNSAVEIMG,mnFile);
  mnBackground=newMenuItem(MNCHANGEBG,mnFile);
  mnClearBackground=newMenuItem(MNCLEARBG,mnFile);
  mnPrint=newMenuItem(MNPRINT,mnFile);
  mnExit=newMenuItem(MNEXIT,mnFile);
  mnEdit=newMenu(MNEDIT);
  mb.add(mnEdit);
  mnAdd=newMenuItem(MNADDNODE,mnEdit);
  mnRen=newMenuItem(MNRENNODE,mnEdit);
  mnLink=newMenuItem(MNLINK,mnEdit);
  mnRem=newMenuItem(MNDELNODE,mnEdit);
  mnResize=newMenuItem(MNRESIZE,mnEdit);
  mnReshape=newMenuItem(MNRESHAPE,mnEdit);
  mnSetFill=newMenuItem(MNFILL,mnEdit);
  mnSetFix=newMenuItem(MNFIX,mnEdit);
  mnImage=newMenuItem(MNNEWIMG,mnEdit);
  mnUnlink=newMenuItem(MNUNLINK,mnEdit);
  mnDefault=newMenu(MNSETDEF);
  mnEdit.add(mnDefault);
  mnName=newMenuItem(MNDEFNAME,mnDefault);
  mnSize=newMenuItem(MNSIZE,mnDefault);
  mnWeight=newMenuItem(MNDEFWEI,mnDefault);
  mnShape=newMenuItem(MNDEFSHAPE,mnDefault);
  mnFill=newMenuItem(MNDEFFILL,mnDefault);
  mnThick=newMenuItem(MNDEFTHICK,mnDefault);
  mnFix=newMenuItem(MNDEFFIX,mnDefault);
  mnCol=newMenu(MNDEFCOL);
  mnDefault.add(mnCol);
  mnColBlack=newMenuItem(MNBLACK,mnCol);
  mnColRed=newMenuItem(MNRED,mnCol);
  mnColGreen=newMenuItem(MNGREEN,mnCol);
  mnColBlue=newMenuItem(MNBLUE,mnCol);
  mnColSpec=newMenuItem(MNSPEC,mnCol);
  mnColPick=newMenuItem(MNPICK,mnCol);
  mnChange=newMenu(MNCHANGE);
  mnEdit.add(mnChange);
  mnColSet2=newMenuItem(MNPCOL,mnChange);
  mnWeight2=newMenuItem(MNPWEI,mnChange);
  mnResize2=newMenuItem(MNPRESIZE,mnChange);
  mnReshape2=newMenuItem(MNPRESHAPE,mnChange);
  mnSetFill2=newMenuItem(MNPFILL,mnChange);
  mnImage2=newMenuItem(MNPIMG,mnChange);
  mnThick2=newMenuItem(MNTHICK,mnChange);
  mnVis2=newMenuItem(MNVIS,mnChange);
  mnSetFix2=newMenuItem(MNPFIX,mnChange);
  mnPath=newMenuItem(MNPATH,mnEdit);
  mnLinear=newMenuItem(MNLINEAR,mnEdit);
  mnView=newMenu(MNVIEW);
  mb.add(mnView);
  mnZoom=newMenu(MNZOOM);
  mnView.add(mnZoom);
  mnZoomIn=newMenuItem(MNZOOMIN,mnZoom);
  mnZoomOut=newMenuItem(MNZOOMOUT,mnZoom);
  mnZoomSet=newMenuItem(MNZOOMSET,mnZoom);
  mnShowWeight=newMenuItem(MNHIDEWEI,mnView);
  mnShowLabel=newMenuItem(MNHIDELABS,mnView);
  mnReset=newMenuItem(MNRESET,mnView);
  mnAdapt=newMenuItem(MNADAPT,mnView);
  mnSearch=newMenu(MNSEARCH);
  mb.add(mnSearch);
  mnSelect=newMenu(MNSEL);
  mnSearch.add(mnSelect);
  mnSelAll=newMenuItem(MNSELALL,mnSelect);
  mnDeselAll=newMenuItem(MNDESELALL,mnSelect);
  mnSelNode=newMenuItem(MNSELNODE,mnSelect);
  mnMinP=newMenuItem(MNMINP,mnSearch);
  mnMinL=newMenuItem(MNMINL,mnSearch);
  mnPoint=newMenu(MNPOINT);
  mb.add(mnPoint);
  mnAdd1=newMenuItem(MNPADD,mnPoint);
  mnRen1=newMenuItem(MNPREN,mnPoint);
  mnLink1=newMenuItem(MNPLINK,mnPoint);
  mnRem1=newMenuItem(MNPDEL,mnPoint);
  mnColSet1=newMenuItem(MNPCOL,mnPoint);
  mnWeight1=newMenuItem(MNPWEI,mnPoint);
  mnResize1=newMenuItem(MNPRESIZE,mnPoint);
  mnReshape1=newMenuItem(MNPRESHAPE,mnPoint);
  mnSetFill1=newMenuItem(MNPFILL,mnPoint);
  mnImage1=newMenuItem(MNPIMG,mnPoint);
  mnThick1=newMenuItem(MNTHICK,mnPoint);
  mnVis1=newMenuItem(MNVIS,mnPoint);
  mnSetFix1=newMenuItem(MNPFIX,mnPoint);
  mnUnlink1=newMenuItem(MNPUNLINK,mnPoint);
  mnMinP1=newMenuItem(MNPMINP,mnPoint);
  mnMinL1=newMenuItem(MNPMINL,mnPoint);
  mnServe=newMenu(MNSERVE);
  mb.add(mnServe);
  mnStart=newMenuItem(MNSTART,mnServe);
  mnStop=newMenuItem(MNSTOP,mnServe);
  mnStop.setEnabled(false);
  mnHelp=newMenu(MNQM);
  mb.add(mnHelp);
  mnInfo=newMenuItem(MNABOUT,mnHelp);
  mnGuide=newMenuItem(MNGUIDE,mnHelp);
  mnLang=newMenu(MNDEFLANG);
  mnHelp.add(mnLang);
  mnLangs=new MenuItem[promptText.length];
  for (int nlang=0;nlang<mnLangs.length;nlang++)
    mnLangs[nlang]=newMenuItem(promptText[nlang][0],mnLang);
  setLanguage(0);
  gp.setName(defaultName);
  gp.setWeight(defaultWeight);
  gp.setNodeSize(defaultSize);
  gp.setNodeShape(defaultShape);
  gp.setNodeFill(defaultFill);
  gp.setNodeFixing(defaultFixing);
  gp.addGraphListener(this);
  status.setForeground(Color.white);
  status.setBackground(activeColor);
  String shapeSymbol[]={"O","[]","+"};
  status.setText(words[SNAME]+":"+defaultName+" "+words[SWEIGHT]+":"+defaultWeight+" "+words[SSIZE]+":"+defaultSize+" "+words[SFILL]+":"+(defaultFill?"@":"O")+" "+words[SSHAPE]+":"+((defaultShape<3)?shapeSymbol[defaultShape]:defaultShape)+" "+words[STHICK]+":"+defaultThickness+(server!=null?" ("+port+")":""));
  setMenu(false);
  int prefSizeW=gp.getPreferredSize().width;
  int prefSizeH=gp.getPreferredSize().height;
//  System.out.println(Toolkit.getDefaultToolkit().getScreenSize().width/2+" "+prefSizeW/2+" "+Toolkit.getDefaultToolkit().getScreenSize().height/2+" "+prefSizeH/2);
  int topx,topy;
  topx=Toolkit.getDefaultToolkit().getScreenSize().width/2 - prefSizeW/2;
  topy=Toolkit.getDefaultToolkit().getScreenSize().height/2 - prefSizeH/2-50;
//  System.out.println("topx="+topx+" topy="+topy);
  if (topx<0)
    topx=0;
  if (topy<0)
    topy=0;
  setLocation(topx,topy);
  pack();
  setVisible(true);
  }
/************
 * Abilita o disabilita le voci del menu
 * @param ena se <b>true</b> abilita le voci del menu, la disabilita altrimenti
 ************/
void setMenu(boolean ena)
  {
  mnSave.setEnabled(ena);
  mnMat.setEnabled(ena);
  mnMerge.setEnabled(ena);
  }

/**********
 * Esegue le azioni attivate da un evento
 * @param ae l'evento gestito
 **********/
public void actionPerformed(ActionEvent ae)
  {
  if (ae.getSource()==mnNew)
    {
    if (canChange())
      {
      gp.clear();
      setMenu(false);
      modified=false;
      }
    }
   else if (ae.getSource()==mnSave||ae.getSource()==mnSaveAs||
            ae.getSource()==mnMat||ae.getSource()==mnMatAs)
    saveGraph(ae.getSource()==mnSave||ae.getSource()==mnSaveAs,
              ae.getSource()==mnSaveAs||ae.getSource()==mnMatAs);
   else if (ae.getSource()==mnSaveImage)
    saveImage();
   else if (ae.getSource()==mnOpen)
    loadGraph(false);
   else if (ae.getSource()==mnMerge)
    loadGraph(true);
   else if (ae.getSource()==mnBackground)
    loadBackground();
   else if (ae.getSource()==mnClearBackground)
    clearBackground();
   else if (ae.getSource()==mnPrint)
    printGraph();
   else if (ae.getSource()==mnExit)
    {
    if (canChange())
      {
      setVisible(false);
      System.exit(0);
      }
    }
   else if (ae.getSource()==mnAdd)
	  addNodeN();
   else if (ae.getSource()==mnAdd1)
	  addNodeP();
   else if (ae.getSource()==mnRen)
    renNodeN();
   else if (ae.getSource()==mnRen1)
    renNodeP();
   else if (ae.getSource()==mnLink)
    link();
   else if (ae.getSource()==mnLink1)
    linkP();
   else if (ae.getSource()==mnRem)
    remNode();
   else if (ae.getSource()==mnRem1)
    remNodeP();
   else if (ae.getSource()==mnColSet1)
    setNodeArcColor();
   else if (ae.getSource()==mnColSet2)
    setNodeArcColorC();
   else if (ae.getSource()==mnSize)
    setNodeSize();
   else if (ae.getSource()==mnResize)
    resizeNodeN();
   else if (ae.getSource()==mnResize1)
    resizeNodeP();
   else if (ae.getSource()==mnResize2)
    resizeNodeC();
   else if (ae.getSource()==mnWeight)
    setWeightN();
   else if (ae.getSource()==mnWeight1)
    setWeightP();
   else if (ae.getSource()==mnWeight2)
    setWeightC();
   else if (ae.getSource()==mnShape)
    setNodeShape();
   else if (ae.getSource()==mnReshape)
    reshapeNodeN();
   else if (ae.getSource()==mnReshape1)
    reshapeNodeP();
   else if (ae.getSource()==mnReshape2)
    reshapeNodeC();
   else if (ae.getSource()==mnFill)
    setNodeFill();
   else if (ae.getSource()==mnSetFill)
    changeFillNodeN();
   else if (ae.getSource()==mnSetFill1)
    changeFillNodeP();
   else if (ae.getSource()==mnSetFill2)
    changeFillNodeC();
   else if (ae.getSource()==mnImage)
    changeImageN();
   else if (ae.getSource()==mnImage1)
    changeImageP();
   else if (ae.getSource()==mnImage2)
    changeImageC();
   else if (ae.getSource()==mnThick)
    setNodeArcThick();
   else if (ae.getSource()==mnThick1)
    setNodeArcThickP();
   else if (ae.getSource()==mnThick2)
    setNodeArcThickC();
   else if (ae.getSource()==mnVis1)
    setNodeArcVis();
   else if (ae.getSource()==mnVis2)
    setNodeArcVisC();
   else if (ae.getSource()==mnFix)
    setNodeFixing();
   else if (ae.getSource()==mnSetFix)
    changeFixingNodeN();
   else if (ae.getSource()==mnSetFix1)
    changeFixingNodeP();
   else if (ae.getSource()==mnSetFix2)
    changeFixingNodeC();
   else if (ae.getSource()==mnUnlink)
    unlink();
   else if (ae.getSource()==mnUnlink1)
    unlinkP();
   else if (ae.getSource()==mnMinL1||ae.getSource()==mnMinP1)
    searchP(ae.getSource()==mnMinL1);
   else if (ae.getSource()==mnMinL||ae.getSource()==mnMinP||ae.getSource()==mnPath)
    searchN(ae.getSource()==mnMinL,ae.getSource()==mnPath);
   else if (ae.getSource()==mnLinear)
    gp.linearise();
   else if (ae.getSource()==mnSelAll)
    gp.selectAll(true);
   else if (ae.getSource()==mnDeselAll)
    gp.selectAll(false);
   else if (ae.getSource()==mnSelNode)
    selNodeN();
   else if (ae.getSource()==mnZoomIn)
    gp.inZoom();
   else if (ae.getSource()==mnZoomOut)
    gp.outZoom();
   else if (ae.getSource()==mnZoomSet)
    setZoom();
   else if (ae.getSource()==mnShowWeight)
    changeShowWeights();
   else if (ae.getSource()==mnShowLabel)
    changeShowLabels();
   else if (ae.getSource()==mnReset)
    gp.reset();
   else if (ae.getSource()==mnAdapt)
    changeAdaption();
   else if (ae.getSource()==mnColRed)
    setSignColor(Color.red);
   else if (ae.getSource()==mnColBlack)
    setSignColor(Color.black);
   else if (ae.getSource()==mnColGreen)
    setSignColor(Color.green);
   else if (ae.getSource()==mnColBlue)
    setSignColor(Color.blue);
   else if (ae.getSource()==mnColSpec)
    setSignColor(null);
   else if (ae.getSource()==mnColPick)
    setSignColor(inputColor());
   else if (ae.getSource()==mnName)
    setNodeName();
   else if (ae.getSource()==mnInfo)
    showInfo();
   else if (ae.getSource()==mnGuide)
    showGuide();
   else if (ae.getSource()==mnStart)
    startServe();
   else if (ae.getSource()==mnStop)
    stopServe();
   else
    {
    for (int lan=0;lan<labels.length;lan++)
      if (ae.getSource()==mnLangs[lan])
        setLanguage(lan);
    }
  refreshValues();
  }
/**********
 * Aggiorna i cambiamenti
 **********/
public void refreshValues()
  {
  activeColor=gp.getColor();   // forse non servono
  defaultWeight=gp.getWeight();   // forse non servono
  defaultName=gp.getName();   // forse non servono
  defaultSize=gp.getNodeSize();   // forse non servono
  defaultShape=gp.getNodeShape();   // forse non servono
  defaultFill=gp.getNodeFill();   // forse non servono
  defaultFixing=gp.getNodeFixing();   // forse non servono
  lastEvent=null;
  status.setBackground(activeColor);
  int ac=activeColor.getRGB();
  int lum=((ac&0xff0000)>>16)|((ac&0x00ff00)>>8)|(ac&0x0000ff);
  if ((lum&0xc0)!=0xc0)
    status.setForeground(Color.white);
   else
    status.setForeground(Color.black);
  String shapeSymbol[]={"O","[]","+"};
  status.setText(words[SNAME]+":"+defaultName+" "+words[SWEIGHT]+":"+defaultWeight+" "+words[SSIZE]+":"+defaultSize+" "+words[SFILL]+":"+(defaultFill?"@":"O")+" "+words[SSHAPE]+":"+((defaultShape<3)?shapeSymbol[defaultShape]:defaultShape)+" "+words[STHICK]+":"+defaultThickness+(server!=null?" ("+port+")":""));
  if (operation!=REN && operation!=MINL && operation!=MINP && operation!=MINL1 && operation!=MINP1 && operation!=ADD && operation!=REM && operation!=LINK && operation!=LINK1 && operation!=UNL
      && operation!=COLOR && operation!=WEIGHT && operation!=WEIGHT1 && operation!=SIZE && operation!=SIZE1 && operation!=IMAGE && operation!=SHAPE && operation!=SHAPE1 && operation!=FILL && operation!=FILL1
      && operation!=THICKA && operation!=THICKN && operation!=THICK && operation!=THICK1 && operation!=VISIB && operation!=FIX && operation!=FIX1)
    prompts.setText("--");
  inputZone.validate(); // forse non serve
  }
/*************
 * Ritorna una immagine
 * @param ims nome dell'immagine da ritornare
 * @return l'immagine letta
 *************/
public Image getImage(String ims)
  {
  Image im=null;
  if (new File(ims).exists())
    {
    im=Toolkit.getDefaultToolkit().getImage(ims);
    }
   else
    {
    URL imUrl=getClass().getResource(ims);
//    System.out.println("Image "+ims+" in JAR is "+imUrl);
    if (imUrl!=null)
      im=Toolkit.getDefaultToolkit().getImage(imUrl);
    }
  if (im!=null)
    {
    MediaTracker mt=new MediaTracker(gp);
    mt.addImage(im,0);
    try
      {
      mt.waitForAll();
      }
     catch(InterruptedException ie)
      {}
    }
  return im;
  }

/**********
 * Filtra i files da presentare 
 * @param dir la cartella che viene visualizzata
 * @param name il nome del file indicato
 * @return ritorna <b>true</b> se il file indicato e' da presentare, <b>false</b> altrimenti
 **********/
public boolean accept(File dir, String name)
  {
  return false;
  }
/********
 * to remember that a dialog box was open avoiding to use incorrectly the second click
 *********/
boolean openDialog=false;
/************
 * Salva un grafo
 * @param graph se <b>true</b> salva la forma estesa, altrimenti salva la forma compatta
 * @param as se <b>true</b> chiede il nuovo nome del file in cui salvare il grafo, altrimenti usa il nome del file di provenienza
 ************/
void saveGraph(boolean graph, boolean as)
  {
  String ext=(graph?".gph":".maa");
  if (as)
    {
    FileDialog filer1=new FileDialog(this);
    filer1.setMode(FileDialog.SAVE); // Use the SAVE version of the dialog.
    // Make the dialog visible as a modal dialog box.
    filer1.setFile(filename+ext);
    filer1.setFilenameFilter(this);
    filer1.setDirectory(dirname);
    openDialog=true;
    filer1.setVisible(true);
    // Upon return, getFile() will be null if user cancelled the dialog.
    if (filer1.getFile() != null)
      {
      // Non-null file property after return implies user
      // selected a file to open.
      filename=filer1.getFile();
      if (filename.lastIndexOf('.')>=0)
        filename=filename.substring(0,filename.lastIndexOf('.'));
      dirname=filer1.getDirectory();
      setTitle("Graph Editor - "+filename);
      }
    setMenu(true);
    }
  try
    {
    FileWriter fr=new FileWriter(dirname+filename+ext);
    if (graph)
      {
      gp.save(fr);
      }
     else
      gp.g.saveMatrix(fr);
    fr.close();
    }
   catch (IOException ioe)
    {}
  }
/************
 * Carica un grafo
 ************/
void loadGraph(boolean merging)
  {
  if (merging || canChange())
    {
    // Filer makes use of a java.awt.FileDialog, and so its
    // mode property uses the same values as those of FileDialog.
    FileDialog filer1=new FileDialog(this);
    filer1.setFile("*.gph");
    filer1.setFilenameFilter(this);
    filer1.setMode(FileDialog.LOAD); // Use the OPEN version of the dialog.
    // Make the dialog visible as a modal dialog box.
    openDialog=true;
    filer1.setVisible(true);
    // Upon return, getFile() will be null if user cancelled the dialog.
    if (filer1.getFile() != null)
      {
      // Non-null file name after return implies user
      // selected a file to open.
      try
        {
        String ext=".gph";
        filename=filer1.getFile();
        if (filename.lastIndexOf('.')>=0)
          {
          ext=filename.substring(filename.lastIndexOf('.'));
          filename=filename.substring(0,filename.lastIndexOf('.'));
          }
        dirname=filer1.getDirectory();
        setTitle("Graph Editor - "+filename);
//          setTitle("Graph Editor - "+dirname+filename);
        FileReader fr;
        if (ext.equals(".arcs") || ext.equals(".gph"))
          fr=new FileReader(dirname+filename+ext);
         else
          fr=new FileReader(dirname+filename+".gph");
        gp.load(fr,merging);
        gp.setModified(false);
        setMenu(true);
        fr.close();
        }
       catch (IOException ioe)
        {
        System.err.println("Error reading "+dirname+filename+".gph");
        }
      }
    }
  pack();
//  System.out.println("loadGraph dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy+" od="+openDialog);
//  openDialog=false; // non metterlo altrimenti quando si fa doppio click sul dialog per scegliere un file se  interno al Panel fa il drag
  }

/************
 * Cancella il background del grafo
 ************/
void clearBackground()
  {
  gp.setBackImage((String)null);
  }

/************
 * Carica il background del grafo
 ************/
void loadBackground()
  {
  // Filer makes use of a java.awt.FileDialog, and so its
  // mode property uses the same values as those of FileDialog.
  FileDialog filer1=new FileDialog(this);
  filer1.setFile("*.*");
  filer1.setFilenameFilter(this);
  filer1.setMode(FileDialog.LOAD); // Use the OPEN version of the dialog.
  // Make the dialog visible as a modal dialog box.
  openDialog=true;
  filer1.setVisible(true);
  // Upon return, getFile() will be null if user cancelled the dialog.
  if (filer1.getFile() != null)
    try
      {
      File fullName=new File(filer1.getDirectory(),filer1.getFile()),cwd=new File(".");
      String filename;
      if (fullName.getCanonicalPath().startsWith(cwd.getCanonicalPath()))
        filename=fullName.getCanonicalPath().substring(cwd.getCanonicalPath().length());
       else
        filename=fullName.getCanonicalPath();
//      System.out.println("dirs= "+fullName.getCanonicalPath()+" "+cwd.getCanonicalPath());
//      System.out.println("filename= "+filename);
      gp.setBackImage(filename);
      }
     catch (IOException ioe)
      {
      }
  }

/************
 * Salva l'immagine del grafo
 ************/ 
private void saveImage()
  {
  BufferedImage off_Image =  new BufferedImage(gp.getWidth(),gp.getHeight(),BufferedImage.TYPE_INT_ARGB);
  Graphics2D g2 = off_Image.createGraphics();
  gp.print(g2);
  // Filer makes use of a java.awt.FileDialog, and so its
  // mode property uses the same values as those of FileDialog.
  FileDialog filer1=new FileDialog(this);
  filer1.setFile("*.png");
  filer1.setFilenameFilter(this);
  filer1.setMode(FileDialog.SAVE); // Use the SAVE version of the dialog.
  // Make the dialog visible as a modal dialog box.
  openDialog=true;
  filer1.setVisible(true);
  // Upon return, getFile() will be null if user cancelled the dialog.
  if (filer1.getFile() != null)
    {
    File[] filename=filer1.getFiles();
    if (filename.length>0)
    try
      {
      // retrieve image
        ImageIO.write(off_Image, "png", filename[0]);
      }
     catch (IOException e)
      {
      }
    }
  }

/************
 * Stampa il grafo
 ************/
private void printGraph()
  {
  Properties prop= new Properties();
  Toolkit   tk= Toolkit.getDefaultToolkit();    // Acquisiamo il toolkit
  PrintJob  pj= tk.getPrintJob(this,"Graph "+filename,prop);
  if (pj!=null)
  	{
    Graphics g = pj.getGraphics();   // Acquisiamo una pagina
    gp.print(g);
    g.dispose();
    pj.end();
  	}
   else
  	System.err.println("Error printing: no print job");
  }

/************
 * Aggiunge un nodo al grafo indicando il nome dopo aver inserito la posizione
 ************/
private void addNodeP()
  {
  operation=ADD;
  prompts.setText(prompt[ADD1]);
  }
/************
 * Aggiunge un nodo al grafo indicandone il nome
 ************/
private void addNodeN()
  {
  String nn=inputText(prompt[ADD]);
  if (nn!=null)
    {
    gp.addNode(nn,activeColor);
    }
  }
/************
 * Rinomina un nodo del grafo indicandolo col mouse
 ************/
private void renNodeP()
  {
  operation=REN;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Rinomina un nodo del grafo indicandone il nome
 ************/
void renNodeN()
  {
  String nn=inputText(prompt[REN]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>1)
      gp.renameNode(st.nextToken(),st.nextToken());
    }
  }
/************
 * Seleziona o deseleziona un nodo del grafo indicandone il nome
 ************/
void selNodeN()
  {
  String nn=inputText(prompt[NAME]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>0)
      { 
      NodeSign<Object> ns=gp.getNode(st.nextToken());
      ns.selected=!ns.selected;
      }
    }
  repaint();
  }
/************
 * Stabilisce il colore dei segni e degli archi di default
 * @param c il colore dei prossimi segni
 ************/
void setSignColor(Color c)
  {
  if (c==null)
    {
    try
      {
      String nn=inputText(prompt[COLOR]);  // legge il codice esadecimale
      if (nn!=null)
        {
        activeColor=new Color(parseInt(nn.trim()));
        }
      }
     catch (NumberFormatException nfe)
      {
      }
    }
   else
    activeColor=c;
  status.setBackground(activeColor);
  gp.setColor(activeColor);
  }
/************
 * Stabilisce il nome del prossimo nodo
 ************/
void setNodeName()
  {
  defaultName=inputText(prompt[NAME]).trim();
  gp.setName(defaultName);
  }
/************
 * Stabilisce il peso di un arco e dei prossimi puntandolo col mouse
 ************/
void setWeightP()
  {
  operation=WEIGHT;
  prompts.setText(prompt[CLICKONARC]);
  }
/************
 * Stabilisce il peso di default per un arco puntandolo col mouse
 ************/
void setWeightC()
  {
  operation=WEIGHT1;
  prompts.setText(prompt[CLICKONARC]);
  }
/************
 * Stabilisce il peso dei prossimi archi
 ************/
void setWeightN()
  {
  try
    {
    String nn=inputText(prompt[WEIGHT],defaultWeight+"");
    if (nn!=null)
      {
      defaultWeight=Double.parseDouble(nn.trim());
      }
    }
   catch (NumberFormatException nfe)
    {
    }
  gp.setWeight(defaultWeight);
  }
/************
 * Stabilisce il colore dei prossimi archi o nodi
 ************/
void setNodeArcColor()
  {
  operation=COLOR;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Cambia il colore di un arco o nodo e dei prossimi
 ************/
void setNodeArcColorC()
  {
  operation=COLOR;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Stabilisce la forma dei segni
 ************/
private void setNodeSize()
  {
  String nn=inputText(prompt[SIZE],defaultSize+"");
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>0)
      defaultSize=parseInt(st.nextToken());
    gp.setNodeSize(defaultSize);
    }
  }

/************
 * Modifica la dimensione di un nodo del grafo indicandolo col mouse
 ************/
private void resizeNodeP()
  {
  operation=SIZE;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica la dimensione di un nodo del grafo indicandolo col mouse
 ************/
private void resizeNodeC()
  {
  operation=SIZE1;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica la dimensione di un nodo dal grafo indicandone il nome
 ************/
private void resizeNodeN()
  {
  String nn=inputText(prompt[SIZE]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>1)
      gp.resizeNode(st.nextToken(),parseInt(st.nextToken()));
    }
  }
/************
 * Stabilisce la forma dei segni
 ************/
void setNodeShape()
  {
  int oldShape;
  oldShape=defaultShape;
  String type;
  if (oldShape==NodeSign.CIRCLE)
    type=words[SCIRCLE];
   else if (oldShape==NodeSign.SQUARE)
    type=words[SSQUARE];
   else if (oldShape==NodeSign.CROSS)
    type=words[SCROSS];
   else
    type=""+defaultShape;
  String nn=inputText(words[PSHAPE],type,true);
  if (nn!=null)
    {
    if (nn.equalsIgnoreCase(words[SCIRCLE]))
      defaultShape=NodeSign.CIRCLE;
     else if (nn.equalsIgnoreCase(words[SSQUARE]))
      defaultShape=NodeSign.SQUARE;
     else if (nn.equalsIgnoreCase(words[SCROSS]))
      defaultShape=NodeSign.CROSS;
     else
      defaultShape=parseInt(nn);
    }
  gp.setNodeShape(defaultShape);
  }
/************
 * Modifica la forma di un nodo del grafo indicandolo col mouse
 ************/
private void reshapeNodeP()
  {
  operation=SHAPE;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica la forma di un nodo del grafo indicandolo col mouse
 ************/
private void reshapeNodeC()
  {
  operation=SHAPE1;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica la forma di un nodo del grafo indicandone il nome
 ************/
void reshapeNodeN()
  {
  String nnLine=inputText(prompt[SHAPE]);
  if (nnLine!=null)
    {
    StringTokenizer st=new StringTokenizer(nnLine);
    if (st.countTokens()>1)
      {
      String nodeName=st.nextToken();
      int oldShape;
      oldShape=defaultShape;
      String type;
      if (oldShape==NodeSign.CIRCLE)
        type=words[SCIRCLE];
       else if (oldShape==NodeSign.SQUARE)
        type=words[SSQUARE];
       else if (oldShape==NodeSign.CROSS)
        type=words[SCROSS];
       else
        type=""+defaultShape;
      String nn=st.nextToken();
      if (nn!=null)
        {
        if (nn.equalsIgnoreCase(words[SCIRCLE]))
          defaultShape=NodeSign.CIRCLE;
         else if (nn.equalsIgnoreCase(words[SSQUARE]))
          defaultShape=NodeSign.SQUARE;
         else if (nn.equalsIgnoreCase(words[SCROSS]))
          defaultShape=NodeSign.CROSS;
         else
          defaultShape=parseInt(nn);
        }
      gp.reshapeNode(nodeName,defaultShape);
      }
    }
  }
/************
 * Stabilisce il riempimento dei segni
 ************/
void setNodeFill()
  {
  String nn=inputText(words[PFILL],(defaultFill?words[STRUE]:words[SFALSE]),true);
  if (nn!=null)
    {
    if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
      defaultFill=false;
     else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
      defaultFill=true;
     else defaultFill=(parseInt(nn)==0)?false:true;
    }
  gp.setNodeFill(defaultFill);
  }
/************
 * Modifica il riempimento di un nodo del grafo indicandolo col mouse
 ************/
private void changeFillNodeP()
  {
  operation=FILL;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica il riempimento di un nodo del grafo indicandolo col mouse
 ************/
private void changeFillNodeC()
  {
  operation=FILL1;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica il riempimento di un nodo del grafo indicandone il nome
 ************/
void changeFillNodeN()
  {
  String input=inputText(prompt[FILL]);
  if (input!=null)
    {
    StringTokenizer st=new StringTokenizer(input);
    if (st.countTokens()>1)
      {
      String nodeName=st.nextToken();
      String nn=st.nextToken();
      if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
        defaultFill=false;
       else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
        defaultFill=true;
       else defaultFill=(parseInt(nn)==0)?false:true;
      gp.changeNodeFill(nodeName,defaultFill);
      }
    }
  }
/************
 * Modifica l'immagine di un nodo del grafo indicandolo col mouse
 ************/
private void changeImageP()
  {
  operation=IMAGE;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica l'immagine di un nodo del grafo indicandolo col mouse
 ************/
private void changeImageC()
  {
  operation=IMAGE;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica l'immagine di un nodo dal grafo indicandone il nome
 ************/
void changeImageN()
  {
  String nn=inputText(prompt[IMAGE]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>1)
      gp.changeNodeImage(st.nextToken(),st.nextToken());
    }
  }
/************
 * Stabilisce lo spessore dei segni
 ************/
private void setNodeArcThick()
  {
  String nn=inputText(prompt[THICK],defaultThickness+"");
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>0)
      defaultThickness=parseInt(st.nextToken());
    }
  gp.setThickness(defaultThickness);
  }
/************
 * Stabilisce lo spessore dei prossimi archi o nodi
 ************/
void setNodeArcThickP()
  {
  operation=THICK;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Cambia lo spessore di un arco o nodo e dei prossimi
 ************/
void setNodeArcThickC()
  {
  operation=THICK1;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Stabilisce la visibilit dei prossimi archi o nodi
 ************/
void setNodeArcVis()
  {
  operation=VISIB;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Cambia la visibilit di un arco o nodo e dei prossimi
 ************/
void setNodeArcVisC()
  {
  operation=VISIB;
  prompts.setText(prompt[CLICKONSOME]);
  }
/************
 * Stabilisce il fissaggio dei nodi
 ************/
private void setNodeFixing()
  {
  String nn=inputText(words[PFIX], (defaultFixing?words[STRUE]:words[SFALSE]),true);
  if (nn!=null)
    {
    if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
      defaultFixing=false;
     else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
      defaultFixing=true;
     else defaultFixing=(parseInt(nn)==0)?false:true;
    }
  gp.setNodeFixing(defaultFixing);
  }
/************
 * Stabilisce il fissaggio dei nodi
 ************/
void changeFixingNodeP()
  {
  operation=FIX;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Cambia il fissaggio di un nodo e dei prossimi
 ************/
void changeFixingNodeC()
  {
  operation=FIX1;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Modifica il fissaggio di un nodo del grafo indicandone il nome
 ************/
void changeFixingNodeN()
  {
  String input=inputText(prompt[FIX]);
  if (input!=null)
    {
    StringTokenizer st=new StringTokenizer(input);
    if (st.countTokens()>1)
      {
      String nodeName=st.nextToken();
      String nn=st.nextToken();
      if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
          defaultFixing=false;
       else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
          defaultFixing=true;
       else defaultFixing=(parseInt(nn)==0)?false:true;
      gp.changeNodeFixing(nodeName,defaultFixing);
      }
    }
  }
/************
 * Rimuove un nodo dal grafo
 ************/
private void remNodeP()
  {
  operation=REM;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Cancella un nodo
 ************/
void remNode()
  {
  String nn=inputText(prompt[REM]);
  if (nn!=null)
    {
    gp.removeNode(nn);
    }
  }
/************
 * Crea un arco nel grafo indicandolo col mouse
 ************/
private void linkP()
  {
  operation=LINK;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Crea un arco nel grafo
 ************/
void link()
  {
  String nn=inputText(prompt[LINK]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    switch (st.countTokens())
      {
      case 2:
        gp.addArc(st.nextToken(),st.nextToken(),activeColor,defaultWeight);
        break;
      case 3:
        try
          {
          gp.addArc(st.nextToken(),st.nextToken(),activeColor,Double.parseDouble(st.nextToken()));
          }
         catch (NumberFormatException nfe)
          {
          }
        break;
      }
    }
  }
/************
 * Cancella un arco del grafo indicandolo col mouse
 ************/
private void unlinkP()
  {
  operation=UNL;
  prompts.setText(prompt[CLICKONARC]);
  }
/************
 * Cancella un arco del grafo
 ************/
void unlink()
  {
  String nn=inputText(prompt[UNL]);
  if (nn!=null)
    {
    StringTokenizer st=new StringTokenizer(nn);
    if (st.countTokens()>1)
      {
      gp.removeArc(st.nextToken(),st.nextToken());
      }
    }
  }

/************
 * Cambia la visualizzazione dei pesi degli archi nel grafo
 ************/
void changeShowWeights()
  {
  gp.setShowWeights(!gp.getShowWeights());
  if (gp.getShowWeights())
    setMenuText(mnShowWeight,label[MNHIDEWEI]);
   else
    setMenuText(mnShowWeight,label[MNSHOWWEI]);
  }

/************
 * Cambia la visualizzazione delle etichette dei nodi nel grafo
 ************/
void changeShowLabels()
  {
  gp.setShowNames(!gp.getShowNames());
  if (gp.getShowNames())
    setMenuText(mnShowLabel,label[MNHIDELABS]);
   else
    setMenuText(mnShowLabel,label[MNSHOWLABS]);
  }

/************
 * Cambia la visualizzazione delle etichette dei nodi nel grafo
 ************/
void changeAdaption()
  {
  gp.setAdaptive(!gp.isAdaptive());
  if (gp.isAdaptive())
    setMenuText(mnAdapt,label[MNFREEZE]);
   else
    setMenuText(mnAdapt,label[MNADAPT]);
  }

/************
 * Cerca il percorso minimo nel grafo
 * @param length <b>true</b> se viene cercata la minima lunghezza, altrimenti cerca il peso minimo
 ************/
void searchP(boolean length)
  {
  if (length)
    operation=MINL;
   else
    operation=MINP;
  prompts.setText(prompt[CLICKONNODE]);
  }
/************
 * Evidenzia un percorso nel grafo
 * @param length <b>true</b> se viene cercata la minima lunghezza, altrimenti evidenzia il percorso di peso minimo
 * @param path <b>true</b> se si richiede un percorso indicato, altriemnti evidenzia il percorso di peso minimo
 ************/
void searchN(boolean length, boolean path)
  {
  String[] p=null;
  if (length)
    {
    String nn=inputText(prompt[MINL]);
    if (nn!=null)
      {
      StringTokenizer st=new StringTokenizer(nn);
      if (st.countTokens()>1)
        p=gp.g.minLengthPath(st.nextToken(),st.nextToken());
      }
    }
   else if (path)
    {
    String nn=inputText(prompt[PATH]);
    if (nn!=null)
      {
      StringTokenizer st=new StringTokenizer(nn);
      p=new String[st.countTokens()];
      for (int i=0;st.hasMoreTokens();i++)
        p[i]=st.nextToken();
      }
    }
   else
    {
    String nn=inputText(prompt[MINP]);
    if (nn!=null)
      {
      StringTokenizer st=new StringTokenizer(nn);
      if (st.countTokens()>1)
        p=gp.g.minPricePath(st.nextToken(),st.nextToken());
      }
    }
  if (p!=null)
    {
    gp.drawPath(activeColor,p);
    }
  }
/************
 * Stabilisce l'ingrandimento dello zoom
 ************/
void setZoom()
  {
//  System.out.println("set zoom "+gp.getZoom());
  String ans=inputText(prompt[ZOOM],""+gp.getZoom());
  if (ans!=null)
    {
    int zv=parseInt(ans.trim());
    gp.setZoom(zv);
    }
  }
/************
 * Fornisce le informazioni sul programma
 ************/
void showInfo()
  {
  warn(appInfo+"\n "+words[SVERSION]+" "+version);
  }
/************
 * Fornisce le istruzioni sul programma
 ************/
void showGuide()
  {
  alert(label[MNGUIDE],guide);
  }
/************
 * Modifica il testo di una voce di menu'
 * @param mi la voce di menu'
 * @param text il nuovo testo della voce di menu'
 ************/
public void setMenuText(MenuItem mi,String text)
  {
  mi.setLabel(text);
  }
/************
 * Stabilisce la lingua dell'interfaccia
 * @param lang l'indice della lingua di interfaccia
 ************/
void setLanguage(int nlang)
  {
  guide=guides[nlang];
  prompt=promptText[nlang];
  label=labels[nlang];
  warnMessage=warnMessageText[nlang];
  words=strings[nlang];
  gp.setLanguage(voices[nlang],promptPU[nlang]);
  setMenuText(mnFile,label[MNFILE]);
  setMenuText(mnNew,label[MNNEW]);
  setMenuText(mnOpen,label[MNOPEN]);
  setMenuText(mnMerge,label[MNMERGE]);
  setMenuText(mnSave,label[MNSAVE]);
  setMenuText(mnSaveAs,label[MNSAVEAS]);
  setMenuText(mnMat,label[MNMAT]);
  setMenuText(mnMatAs,label[MNMATAS]);
  setMenuText(mnSaveImage,label[MNSAVEIMG]);
  setMenuText(mnBackground,label[MNCHANGEBG]);
  setMenuText(mnClearBackground,label[MNCLEARBG]);
  setMenuText(mnPrint,label[MNPRINT]);
  setMenuText(mnExit,label[MNEXIT]);
  setMenuText(mnEdit,label[MNEDIT]);
  setMenuText(mnAdd,label[MNADDNODE]);
  setMenuText(mnRen,label[MNRENNODE]);
  setMenuText(mnLink,label[MNLINK]);
  setMenuText(mnRem,label[MNDELNODE]);
  setMenuText(mnResize,label[MNRESIZE]);
  setMenuText(mnReshape,label[MNRESHAPE]);
  setMenuText(mnSetFill,label[MNFILL]);
  setMenuText(mnSetFix,label[MNFIX]);
  setMenuText(mnImage,label[MNNEWIMG]);
  setMenuText(mnUnlink,label[MNUNLINK]);
  setMenuText(mnDefault,label[MNSETDEF]);
  setMenuText(mnChange,label[MNCHANGE]);
  setMenuText(mnSelect,label[MNSEL]);
  setMenuText(mnSelAll,label[MNSELALL]);
  setMenuText(mnDeselAll,label[MNDESELALL]);
  setMenuText(mnName,label[MNDEFNAME]);
  setMenuText(mnSize,label[MNSIZE]);
  setMenuText(mnWeight,label[MNDEFWEI]);
  setMenuText(mnShape,label[MNDEFSHAPE]);
  setMenuText(mnFill,label[MNDEFFILL]);
  setMenuText(mnThick,label[MNDEFTHICK]);
  setMenuText(mnFix,label[MNDEFFIX]);
  setMenuText(mnCol,label[MNDEFCOL]);
  setMenuText(mnColBlack,label[MNBLACK]);
  setMenuText(mnColRed,label[MNRED]);
  setMenuText(mnColGreen,label[MNGREEN]);
  setMenuText(mnColBlue,label[MNBLUE]);
  setMenuText(mnColSpec,label[MNSPEC]);
  setMenuText(mnColPick,label[MNPICK]);
  setMenuText(mnLang,label[MNDEFLANG]);
  for (int nlangs=0;nlangs<promptText.length;nlangs++)
    setMenuText(mnLangs[nlangs],promptText[nlangs][0]);
  setMenuText(mnPath,label[MNPATH]);
  setMenuText(mnLinear,label[MNLINEAR]);
  setMenuText(mnView,label[MNVIEW]);
  setMenuText(mnZoom,label[MNZOOM]);
  setMenuText(mnZoomIn,label[MNZOOMIN]);
  setMenuText(mnZoomOut,label[MNZOOMOUT]);
  setMenuText(mnZoomSet,label[MNZOOMSET]);
  setMenuText(mnShowWeight,label[MNHIDEWEI]);
  setMenuText(mnShowLabel,label[MNHIDELABS]);
  setMenuText(mnReset,label[MNRESET]);
  setMenuText(mnAdapt,label[MNADAPT]);
  setMenuText(mnSearch,label[MNSEARCH]);
  setMenuText(mnMinP,label[MNMINP]);
  setMenuText(mnMinL,label[MNMINL]);
  setMenuText(mnPoint,label[MNPOINT]);
  setMenuText(mnAdd1,label[MNPADD]);
  setMenuText(mnRen1,label[MNPREN]);
  setMenuText(mnLink1,label[MNPLINK]);
  setMenuText(mnRem1,label[MNPDEL]);
  setMenuText(mnColSet1,label[MNPCOL]);
  setMenuText(mnWeight1,label[MNPWEI]);
  setMenuText(mnResize1,label[MNPRESIZE]);
  setMenuText(mnReshape1,label[MNPRESHAPE]);
  setMenuText(mnSetFill1,label[MNPFILL]);
  setMenuText(mnImage1,label[MNPIMG]);
  setMenuText(mnThick1,label[MNTHICK]);
  setMenuText(mnVis1,label[MNVIS]);
  setMenuText(mnSetFix1,label[MNPFIX]);
  setMenuText(mnColSet2,label[MNPCOL]);
  setMenuText(mnWeight2,label[MNPWEI]);
  setMenuText(mnResize2,label[MNPRESIZE]);
  setMenuText(mnReshape2,label[MNPRESHAPE]);
  setMenuText(mnSetFill2,label[MNPFILL]);
  setMenuText(mnImage2,label[MNPIMG]);
  setMenuText(mnThick2,label[MNTHICK]);
  setMenuText(mnVis2,label[MNVIS]);
  setMenuText(mnSetFix2,label[MNPFIX]);
  setMenuText(mnUnlink1,label[MNPUNLINK]);
  setMenuText(mnMinP1,label[MNPMINP]);
  setMenuText(mnMinL1,label[MNPMINL]);
  setMenuText(mnServe,label[MNSERVE]);
  setMenuText(mnStart,label[MNSTART]);
  setMenuText(mnStop,label[MNSTOP]);
  setMenuText(mnHelp,label[MNQM]);
  setMenuText(mnInfo,label[MNABOUT]);
  setMenuText(mnGuide,label[MNGUIDE]);
  }
/************
 * Avvisa che si sta per perdere le modifiche
 ************/
private boolean canChange()
  {
  return (!modified && !gp.isModified()) || warn(warnMessage[0],warnMessage[1]);
  }
/*****************
 * Permette di selezionare un colore tramite un ColorPickPanel
 *****************/
private Color inputColor()
  {
  final Dialog d=new Dialog(this,"Choose a color",true);
  d.addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      d.setVisible(false);
      d.dispose();
      }
    });
  ColorPickPanel cpp=new ColorPickPanel(gp.getColor());
  d.add(cpp);
  d.setBounds(getBounds().x+getWidth()/2-100,getBounds().y+getHeight()/2,100,30);
  d.pack();
  d.setVisible(true);
  return cpp.getColor();
  }

/***************
 * invocata quando un arco viene selezionato
 * @param ge il descrittore dell'evento
 ***************/
public void arcSelected(GraphEvent ge)
  {
  }
/***************
 * invocata quando un nodo viene selezionato
 * @param ge il descrittore dell'evento
 ***************/
public void nodeSelected(GraphEvent ge)
  {
  }
/***************
 * invocata quando un arco viene aggiunto
 * @param ge il descrittore dell'evento
 ***************/
public void arcAdded(GraphEvent ge)
  {
  }
/***************
 * invocata quando un nodo viene aggiunto
 * @param ge il descrittore dell'evento
 ***************/
public void nodeAdded(GraphEvent ge)
  {
  }
/***************
 * invocata quando un arco viene rimosso
 * @param ge il descrittore dell'evento
 ***************/
public void arcRemoved(GraphEvent ge)
  {
  }
/***************
 * invocata quando un nodo viene rimosso
 * @param ge il descrittore dell'evento
 ***************/
public void nodeRemoved(GraphEvent ge)
  {
  }
/***************
 * invocata quando viene fatto uno zoom sul pannello
 * @param ge il descrittore dell'evento
 ***************/
public void zoomed(GraphEvent ge)
  {
  }
/***************
 * invocata quando il pannello viene spostato
 * @param ge il descrittore dell'evento
 ***************/
public void moved(GraphEvent ge)
  {
  }
/***************
 * invocata quando il pannello viene modificato
 * @param ge il descrittore dell'evento
 ***************/
public void changed(GraphEvent ge)
  {
//  System.err.println("Grafo cambiato");
  set(ge);
  }

/***************
 * invocata quando vengono modificati i default del pannello
 * @param ge il descrittore dell'evento
 ***************/
 @SuppressWarnings({"unchecked"})
public void set(GraphEvent ge)
  {
  GraphPanel gp=(GraphPanel)(ge.getSource());
  defaultName=gp.getName();
  defaultSize=gp.getNodeSize();
  defaultWeight=gp.getWeight();
  defaultShape=gp.getNodeShape();
  defaultThickness=gp.getThickness();
  activeColor=gp.getColor();
  refreshValues();
  repaint();
  }

/**
 * Implementa un server su una Socket che
 * fornisce informazioni su un grafo secondo il protocollo
 * seguente
 * 1) se il server riceve una linea di testo nel seguente formato
 *     ARCS_ <n1> <n2>
 * dove n1 e n2 sono i nomi di due nodi del grafo ritorna un
 * valore intero su 1 byte contenente il numero di
 * connessioni tra i due nodi indicati, ritorna -1 se almeno
 * uno dei nodi non esiste
 *     ARCS <n1> <n2>
 * come sopra ma ritorna il valore intero come sequenza di caratteri
 * 2) se il server riceve una linea di testo nel seguente formato
 *     DEGREE_
 * ritorna un valore intero su 2 bytes con il numero di nodi del
 * grafo
 *     DEGREE
 * come sopra ma ritorna il valore intero come sequenza di caratteri
 * 3) se il server riceve una linea di testo nel seguente formato
 *     INDEX_ <n1>
 * dove n1  il nome di un nodo del grafo ritorna un valore intero
 * su 2 bytes contenente il numero dordine (a partire da 0)
 * del nodo nel grafo, -1 se il nodo non esiste.
 *     INDEX <n1>
 * come sopra ma ritorna il valore intero come sequenza di caratteri
 * 4) se il server riceve una linea di testo nel seguente formato
 *     NAME_ <i1>
 * dove i1  l'indice di un nodo del grafo ritorna una stringa
 * contenente il nome del nodo di indice n1 seguita da un byte di valore 1.
 *     NAME <i1>
 * come sopra ma andando a linea nuova invece che inserire il byte a 1.
 **/
class ClientManager extends Thread
{
Socket ins;
Scanner in;
PrintWriter out;
DataOutputStream dos;
/**
 * Crea un nuovo GraphManager
 *
 * @param s la socket su cui viene fornito il servizio.
 **/
public ClientManager(Socket s)
  {
  ins=s;
  try
    {
    in=new Scanner(s.getInputStream());
    out=new PrintWriter(s.getOutputStream());
    dos=new DataOutputStream(s.getOutputStream());
    }
   catch (IOException ioe)
    {
    }
  start();
  }
public void run()
  {
  try
    {
    String com;
    while (in!=null && in.hasNext() && (com=in.next())!=null)
      {
//      System.out.println("letto "+com);
      if (com.equals("INDEX"))
        {
        int ind=gp.findNode(in.nextLine().trim());
        out.println(""+ind);
        }
      if (com.equals("INDEX_"))
        {
        int ind=gp.findNode(in.nextLine().trim());
        dos.writeByte((byte)ind);
        }
       else if (com.equals("DEGREE"))
        {
        int ind=gp.getGraph().degree();
        out.println(""+ind);
        }
       else if (com.equals("DEGREE_"))
        {
        int ind=gp.getGraph().degree();
        dos.writeShort((short)ind);
        }
       else if (com.equals("ARCS") || com.equals("ARCS_"))
        {
        ArcSign arc=gp.getArc(in.next().trim(),in.next().trim());
        int na;
        for (na=0;arc!=null;na++)
          arc=arc.next;
        if (com.equals("ARCS_"))
          dos.writeByte((byte)na);
         else
          out.println(""+na);
        }
       else if (com.equals("WEIGHTS") || com.equals("WEIGHTS_"))
        {
        String from=in.next().trim(),to=in.next().trim();
        ArcSign arc=gp.getArc(from,to);
        int na;
        ArcSign a=arc;
        for (na=0;arc!=null;na++)
          arc=arc.next;
        if (com.equals("WEIGHTS_"))
          {
          dos.writeByte((byte)na);
          for (arc=a;arc!=null;na++)
            {
            dos.writeDouble(arc.a.p);
            arc=arc.next;
            }
          }
         else
          {
          out.print(""+na);
          for (arc=a;arc!=null;na++)
            {
            out.print(" "+arc.a.p);
            arc=arc.next;
            }
          out.println();
          }
        }
       else if (com.equals("NAME"))
        {
        String name=gp.getGraph().getNode(in.nextInt()).name;
        out.println(""+name);
        }
       else if (com.equals("NAME_"))
        {
        String name=gp.getGraph().getNode(in.nextInt()).name;
        dos.writeBytes(name);
        dos.writeChar(1);
        }
      }
    }
   catch (IOException ioe)
    {}
  }
}
int port=-1;
ServerSocket ss;
Thread server;
Vector <ClientManager>cv;
/************
 * Comincia il servizio sulla porta fornita (7823 di default) dellhost indicato
 ************/
public void startServe()
  {
  Scanner sc=new Scanner(inputText(prompt[PORT],(port<0)?"7823":""+port).trim());
  port=sc.nextInt();
  try
    {
    ss=new ServerSocket(port);
    server=new Thread(this);
    server.start();
    mnStart.setEnabled(false);
    mnStop.setEnabled(true);
    }
   catch (IOException ex)
    {
    ss=null;
    }
  }

/************
 * crea un nuovo manager per il client che viene accettato
 ************/
public void run()
  {
  cv=new Vector<ClientManager>();
  while (server!=null)
    {
    try
      {
      Socket ins=ss.accept();
      ClientManager cm=new ClientManager(ins);
      cv.add(cm);
      }
     catch(IOException ioe)
      {}
    }
  }
/************
 * Interrompe il servizio sull'host
 ************/
public void stopServe()
  {
  if (ss!=null && cv!=null)
    try
      {
      ss.close();
      ss=null;
      for (ClientManager climan:cv)
        climan.interrupt();
      cv=null;
      server.interrupt();
      server=null;
      }
     catch (IOException ioe)
      {
      ss=null;
      }
  mnStart.setEnabled(true);
  mnStop.setEnabled(false);
  }

/************
 * Presenta una finestra di dialogo di avvertimento
 *
 * @param tit il titolo del messaggio da presentare
 * @param s il messaggio da presentare
 *
 * @return ritorna <b>true</b> quando il bottone  schiacciato
 ************/
private boolean alert(String tit, String s)
  {
  return warn(tit,s,prompt[OK],null,false);
  }
/************
 * Presenta un finestra di dialogo di avvertimento
 *
 * @param s il messaggio da presentare
 *
 * @return ritorna <b>true</b> quando il bottone  schiacciato
 ************/
private boolean warn(String s)
  {
  return warn(s,prompt[OK],null,false);
  }
/************
 * Presenta un finestra di dialogo di richiesta di conferma
 *
 * @param s il messaggio da accettare
 * @param c il messaggio per ritornare false
 *
 * @return ritorna <b>true</b> se il bottone con OK  schiacciato, <b>false</b> se  schiacciato il bottone col secondo parametro
 ************/
private boolean warn(String s, String c)
  {
  return warn(s,prompt[OK],c,true);
  }
/************
 * Presenta un finestra di dialogo di avvertimento
 *
 * @param s il messaggio
 * @param ok il messaggio per ritornare true
 * @param no il messaggio per ritornare false
 * @param t il tipo di avviso, se true con due tasti, se false con un tasto solo
 *
 * @return ritorna <b>true</b> se il bottone del secondo parametro  schiacciato, <b>false</b> se  schiacciato il bottone col terzo parametro
 ************/
private boolean warn(String s, String yes, String no, boolean t)
  {
  return warn(s,s,yes,no,t);
  }
/************
 * Presenta un finestra di dialogo di avvertimento
 *
 * @param tit il titolo del messaggio
 * @param s il messaggio
 * @param ok il messaggio per ritornare true
 * @param no il messaggio per ritornare false
 * @param t il tipo di avviso, se true con due tasti, se false con un tasto solo
 *
 * @return ritorna <b>true</b> se il bottone del terzo parametro  schiacciato, <b>false</b> se  schiacciato il bottone col quarto parametro
 ************/
private boolean warn(String tit, String s, String yes, String no, boolean t)
  {
//  prompts.setText(s);
  final Dialog d=new Dialog(this,s,true);
  Panel p=new Panel();
  d.setLayout(new BorderLayout());
  Panel jp=new Panel();
  Scanner mex=new Scanner(s);
  int nl=0;
  for (;mex.hasNextLine();nl++)
    jp.add(new Label(mex.nextLine(),Label.CENTER));
  jp.setLayout(new GridLayout(nl,1));
  Button ok=new Button(yes);
  Button cancel=new Button(no);
  ok.addActionListener(new ActionListener()
    {
    public void actionPerformed(ActionEvent ae)
      {
      setOk(true);
      d.setVisible(false);
      d.dispose();
      }
    });
  cancel.addActionListener(new ActionListener()
    {
    public void actionPerformed(ActionEvent ae)
      {
      setOk(false);
      d.setVisible(false);
      d.dispose();
      }
    });
  d.addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      setOk(false);
      d.setVisible(false);
      d.dispose();
      }
    });
  d.add(jp,BorderLayout.CENTER);
  p.add(ok);
  if (t)
    p.add(cancel);
  d.add(p,BorderLayout.SOUTH);
  d.setBounds(getBounds().x+getWidth()/2-100,getBounds().y+getHeight()/2,100,30);
  d.pack();
  d.setVisible(true);
  return isOk;
  }
/*********
 * Indica che l'avviso  negato
 * @param v stabilisce il valore di isOk
 *********/
private void setOk(boolean v)
  {
  isOk=v;
  }
boolean isOk=false;


/*****************
 * Permette l'input di una stringa tramite un dialog
 * @param t titolo del dialog
 ******************/
private String inputText(String t)
  {
  return inputText(t,"");
  }
/*****************
 * Permette l'input di una stringa tramite un dialog
 * @param t titolo del dialog
 * @param v valore iniziale del dialog
 ******************/
private String inputText(String t,String v)
  {
  return inputText(t,v,true);
  }
/*****************
 * Permette l'input di una stringa tramite un dialog
 * @param t titolo del dialog
 * @param v valore iniziale del dialog
 * @param selected <b>true</b> se il valore iniziale deve essere selezionato, <b>false</b> altrimenti
 ******************/
private String inputText(String t,String v,boolean selected)
  {
  Component par=this;
  for (;!(par instanceof Frame);)
    {
//    System.out.println(par);
    par=par.getParent();
    }
  final Dialog d=new Dialog((Frame)par,t,true);
  TextField text=new TextField(t.length()+5);
  text.setText(v);
  if (selected)
    {
    text.setSelectionStart(0);
    text.setSelectionEnd(text.getText().length());
    }
  text.addActionListener(new ActionListener()
    {
    public void actionPerformed(ActionEvent ae)
      {
      d.setVisible(false);
      d.dispose();
      }
    });
  d.addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      d.setVisible(false);
      d.dispose();
      }
    });
  d.add(text);
  d.setBounds(getBounds().x+getWidth()/2-100,getBounds().y+getHeight()/2,100,30);
  d.pack();
  d.setVisible(true);
//  System.out.println("Passato dopo inputtext");
  String res=text.getText().trim();
  if ("".equals(res))
    return null;
   else
    return res;
  }

/************
 * Nome del primo nodo di un percorsoi
 ************/
String first="";
/************
 * Gestisce l'evento del click sul mouse
 * @param e l'evento gestito
 ************/
public void mouseClicked(MouseEvent e)
//           Invoked when the mouse has been clicked on a component.
  {
//  System.out.println("mouseclicked ge dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy+" od="+openDialog);
  openDialog=false;
  if (operation!=0)
    doOperation(e);
  defaultName=gp.getName();
  defaultWeight=gp.getWeight();
  activeColor=gp.getColor();
  refreshValues();
  repaint();
  }
/************
 * Esegue l'operazione attivata dall'evento
 * @param e l'evento gestito
 ************/
void doOperation(MouseEvent e)
  {
//  System.out.println(operation+" "+defaultName+" "+defaultWeight+" "+activeColor);
  String p[]=null;
  String nodeName=null;
  NodeSign nodeSign=null;
  ArcSign arcSign=null;
  switch (operation)
    {
    case 0:
      break;
    case ADD:
      nodeName=inputText(prompt[ADD],defaultName);
      if (nodeName!=null)
        gp.addNode(nodeName,gp.absoluteX(e.getX()),gp.absoluteY(e.getY()));
      e.consume();
      break;
    case REN:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        String nn=inputText(prompt[REN1]+nodeName,nodeSign.getName());
        if (nn!=null)
          gp.renameNode(nodeName,nn);
        }
      e.consume();
      break;
    case COLOR:
      NodeSign ns=gp.getNode(e.getX(),e.getY());
      if (ns!=null)
        {
        ns.setColor(activeColor);
        gp.setModified(true);
        }
      ArcSign as=gp.getArc(e.getX(),e.getY());
      if (as!=null)
        {
        as.setColor(activeColor);
        gp.setModified(true);
        }
      e.consume();
      break;
    case SIZE:
    case SIZE1:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        if (operation==SIZE)
          {
          String nn=null;
          nn=inputText(prompt[SIZE]+" "+nodeName,nodeSign.getSize()+"");
          if (nn!=null)
            defaultSize=parseInt(nn);
          }
        gp.resizeNode(nodeName,defaultSize);
        }
      e.consume();
      break;
    case WEIGHT:
    case WEIGHT1:
      ArcSign as1=gp.getArc(e.getX(),e.getY());
      if (as1!=null)
        {
        if (operation==WEIGHT)
          try
            {
            String nn=inputText(prompt[WEIGHT],as1.a.p+"");
            if (nn!=null)
              {
              defaultWeight=Double.parseDouble(nn.trim());
              }
            if (as1.a.p!=defaultWeight)
              gp.changeArcWeight(as1.from.getName(),as1.to.getName(),defaultWeight);
            }
           catch (NumberFormatException nfe)
            {
            }
        }
      e.consume();
      break;
    case SHAPE:
    case SHAPE1:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        if (operation==SHAPE)
          {
          int oldShape;
          oldShape=defaultShape;
          String type;
          if (oldShape==NodeSign.CIRCLE)
            type=words[SCIRCLE];
           else if (oldShape==NodeSign.SQUARE)
            type=words[SSQUARE];
           else if (oldShape==NodeSign.CROSS)
            type=words[SCROSS];
           else
            type=""+defaultShape;
          String nn=inputText(prompt[SHAPE1]+nodeName,type);
          if (nn!=null)
            {
            if (nn.equalsIgnoreCase(words[SCIRCLE]))
              defaultShape=NodeSign.CIRCLE;
             else if (nn.equalsIgnoreCase(words[SSQUARE]))
              defaultShape=NodeSign.SQUARE;
             else if (nn.equalsIgnoreCase(words[SCROSS]))
              defaultShape=NodeSign.CROSS;
             else
              defaultShape=parseInt(nn);
            }
          }
        gp.reshapeNode(nodeName,defaultShape);
        }
      e.consume();
      break;
    case FILL:
    case FILL1:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        if (operation==FILL)
          {
          String nn=inputText(prompt[FILL1]+nodeName,(nodeSign.isFilled()?words[STRUE]:words[SFALSE]));
          if (nn!=null)
            if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
              defaultFill=false;
             else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
              defaultFill=true;
             else defaultFill=(parseInt(nn)==0)?false:true;
          }
        gp.changeNodeFill(nodeName,defaultFill);
        }
      e.consume();
      break;
    case IMAGE:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        String nn=inputText(prompt[IMAGE1]+nodeName,nodeSign.getImageName());
        if (nn!=null)
          gp.changeNodeImage(nodeName,nn);
        }
      e.consume();
      break;
    case THICK:
    case THICK1:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        int th=nodeSign.getThickness();
        if (operation==THICK)
          {
          String nn=null;
          nn=inputText(prompt[THICKN]+" "+nodeName,nodeSign.getThickness()+"");
          if (nn!=null)
            defaultThickness=parseInt(nn);
          }
        gp.changeNodeThickness(nodeName,defaultThickness);
        }
      arcSign=gp.getArc(e.getX(),e.getY());
//      System.out.println("trovato arco "+arcSign);
      if (arcSign!=null)
        {
        if (operation==THICK)
          {
          String nn=null;
          nn=inputText(prompt[THICKA],arcSign.getThickness()+"");
          if (nn!=null)
            defaultThickness=parseInt(nn);
          }
        if (arcSign.th!=defaultThickness)
          gp.changeArcThickness(arcSign.from.getName(),arcSign.to.getName(),defaultThickness);
        gp.setModified(true);
        }
      e.consume();
      break;
    case VISIB:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeSign.setVisible(!nodeSign.isVisible());
        gp.setModified(true);
        }
      arcSign=gp.getArc(e.getX(),e.getY());
      if (arcSign!=null)
        {
        arcSign.setVisible(!arcSign.isVisible());
        gp.setModified(true);
        }
      e.consume();
      break;
    case FIX:
    case FIX1:
      nodeSign=gp.getNode(e.getX(),e.getY());
      if (nodeSign!=null)
        {
        nodeName=nodeSign.getName();
        if (operation==FIX)
          {
          String nn=inputText(prompt[FIX1]+nodeName,(nodeSign.isFixed()?words[STRUE]:words[SFALSE]));
          if (nn!=null)
            if (nn.equalsIgnoreCase(words[SFALSE]) || nn.equalsIgnoreCase(words[SNO]))
              defaultFixing=false;
             else if (nn.equalsIgnoreCase(words[STRUE]) || nn.equalsIgnoreCase(words[SYES]))
              defaultFixing=true;
             else defaultFixing=(parseInt(nn)==0)?false:true;
            }
        gp.changeNodeFixing(nodeName,defaultFixing);
        }
      e.consume();
      break;
    case REM:
      String nodeName1=gp.getNodeName(e.getX(),e.getY());
      if (nodeName1!=null)
        gp.removeNode(nodeName1);
      e.consume();
      break;
    case LINK:
      first=gp.getNodeName(e.getX(),e.getY());
//      System.out.println("mouseclick LINK first="+first);
      if (first!=null)
        {
        prompts.setText(prompt[SEC]+first);
        operation=LINK1;
        }
      e.consume();
      break;
    case LINK1:
      String second1=gp.getNodeName(e.getX(),e.getY());
//      System.out.println("mouseclick LINK second="+second1);
      if (second1!=null)
        gp.addArc(first,second1);
      operation=0;
      e.consume();
      break;
    case MINL: case MINP:
      first=gp.getNodeName(e.getX(),e.getY());
      if (first!=null)
        {
        prompts.setText(prompt[SEC]+first);
        switch(operation)
          {
          case MINL:
            operation=MINL1;
            break;
          case MINP:
            operation=MINP1;
            break;
          }
        }
      e.consume();
      break;
    case MINL1: case MINP1:
      String second=gp.getNodeName(e.getX(),e.getY());
      p=null;
      if (second!=null)
        {
        switch (operation)
          {
          case MINP1:
            p=gp.g.minPricePath(first,second);
            break;
          case MINL1:
            p=gp.g.minLengthPath(first,second);
            break;
          }
        }
//      for (int i=0;i<p.length;i++)
//        System.out.println(","+p[i]);
      if (p!=null)
        gp.drawPath(activeColor,p);
      operation=0;
      e.consume();
      break;
    case UNL:
      gp.removeArc(e.getX(),e.getY());
      e.consume();
      break;
    }
  if (operation!=MINL1 && operation!=MINP1 && operation!=LINK1)
    {
    operation=0;
    }
  inputZone.validate();
  }
/******
 * converte una stringa contenente un valore intero nelle diverse basi
 *
 * @param val la stringa contenente il valore intero
 * @return il valore convertito in intero
 ******/
private int parseInt(String val)
  {
  try
    {
    int ris;
  //  System.out.print("<"+val+">");
    if (val.startsWith("0x"))
      ris=Integer.parseInt(val.substring(2),0x10);
     else if (val.startsWith("0b"))
      ris=Integer.parseInt(val.substring(2),0b10);
     else if (val.startsWith("0"))
      ris=Integer.parseInt(val,010);
     else
      ris=Integer.parseInt(val);
    return ris;
    }
   catch (NumberFormatException nfe)
    {
    return 0;
    }
  }
/************
 * Gestisce l'evento dell'entrata del mouse
 * @param e l'evento gestito
 ************/
public void mouseEntered(MouseEvent e)
//           Invoked when the mouse enters a component.
  {
  }
/************
 * Gestisce l'evento dell'uscita del mouse
 * @param e l'evento gestito
 ************/
public void mouseExited(MouseEvent e)
//           Invoked when the mouse exits a component.
  {
  }
/************
 * Gestisce l'evento della pressione sul mouse
 * @param e l'evento gestito
 ************/
public void mousePressed(MouseEvent e)
//           Invoked when a mouse button has been pressed on a component.
  {
//  System.out.println("mousepressed ge dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy+" od="+openDialog);
//  System.out.println("mousePressed con e="+e);
  if (openDialog)
    e.consume();
  openDialog=false;
  }
/************
 * Gestisce l'evento del rilascio del mouse
 * @param e l'evento gestito
 ************/
public void mouseReleased(MouseEvent e)
//           Invoked when a mouse button has been released on a component.
  {
//  System.out.println("mousereleased ge dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy+" od="+openDialog);
//  System.out.println("mouseReleased con od="+openDialog);
  if (openDialog)
    e.consume();
  openDialog=false;
  }
/************
 * Gestisce l'evento del trasinamento del mouse
 * @param e l'evento gestito
 ************/
public void mouseDragged(MouseEvent e)
  {
  refreshValues();
//  System.out.println("mousedragged ge dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy+" od="+openDialog);
  if (openDialog)
    e.consume();
  openDialog=false;
  }
/************
 * Gestisce l'evento del movimento del mouse
 * @param e l'evento gestito
 ************/
public void mouseMoved(MouseEvent e)
  {
  refreshValues();
//  System.out.println("mousemoved dx="+gp.dx+" dy="+gp.dy+" oldx="+gp.oldx+" oldy="+gp.oldy);
  if (openDialog)
    e.consume();
  openDialog=false;
  }

/************
 * Il metodo di lancio dell'applicazione
 * @param a gli argomenti della chiamata
 ************/
public static void main(String a[])
  {
  GraphEditor ge=new GraphEditor();
  }
}
