import java.awt.*;
import java.awt.event.*;
import java.io.*;

/***************
 * Crea un grafo circolare completamente connesso dato un numero di nodi
 ***************/
public class CircleGraphMaker extends Frame implements ActionListener
{
TextField liv;
GraphPanel gp;
/******************
 * Crea un frame in cui  inserito un GraphPanel in cui si pu rappresentare un grafo circolare completamente connesso dando in un textfield il numero dei nodi.
 ******************/
public CircleGraphMaker()
  {
  super("Circle Graph");
  liv=new TextField("indicare il numero di nodi (positivo per un grafo totalmente connesso, negativo per una lista circolare)");
  liv.selectAll();
  gp=new GraphPanel();
  gp.setShowText(false);
  liv.addActionListener(this);
  setLayout(new BorderLayout());
  add(gp,BorderLayout.CENTER);
  add(liv,BorderLayout.SOUTH);
  addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      dispose();
//      System.exit(0);
      }
    });
  pack();
  setVisible(true);
  }
/******************
 * Crea un frame in cui  inserito un GraphPanel in cui si pu rappresentare
 * un grafo circolare completamente connesso dando in un textfield il
 * numero dei nodi.
 * @param s ignorato
 ******************/
public static void main(String s[])
  {
  new CircleGraphMaker();
  }
/******************
 * Aggiorna il GraphPanel con il grafo corrispondente e lo salva nel file cerchio.gph
 ******************/
public void actionPerformed(ActionEvent ae)
  {
  int livello=0;
  String nomi[];
  int mad[][];
//  System.out.println("<<"+liv+">> <<"+gp+">>");
  try
    {
    String s=liv.getText();
    liv.selectAll();
    livello=Integer.parseInt(s);
    }
   catch (NumberFormatException nfe)
    {
    }
  gp.clear();
  if (livello>0)
    {
    int nNodi=livello;
    double drad=(2*Math.PI/livello);
    double rad=0;
    for (int liv=0;liv<livello;liv++,rad+=drad)
      {
      int dim=(gp.getWidth()<gp.getHeight()?gp.getWidth():gp.getHeight());
      int radius= dim/2;
      int x=(int)(Math.cos(rad)*radius),y=(int)(Math.sin(rad)*radius);
//      System.out.println("nodo"+liv+" "+rad+" "+radius+" "+x+" "+y);
//      System.out.println("nNodi="+nNodi+" nNodiLiv="+nNodiLiv+" livello="+liv);
      gp.addNode("nodo"+liv,(int)(radius+Math.cos(rad)*radius),(int)(radius+Math.sin(rad)*radius));
      }
    for (int i=0;i<livello;i++)
      {
      for (int j=0;j<livello;j++)
        {
        if (i!=j)
          gp.addArc("nodo"+i,"nodo"+j);
        }
      }
    FileWriter fr;
    try
      {
      fr=new FileWriter("cerchio.gph");
      gp.save(fr);
      fr.close();
      }
     catch (IOException ioe)
      {}
    }
   else if (livello<0)
    {
    livello=-livello;
    int nNodi=livello;
    nomi=new String[nNodi];
    mad=new int[nNodi][nNodi];
    for (int i=0;i<nNodi;i++)
      {
      nomi[i]="nodo"+i;
      for (int j=0;j<nNodi;j++)
        if (j==i+1)
        	{
          mad[i][j]=1;
          mad[j][i]=1;
        	}
      }
    mad[nNodi-1][0]=1;
    gp.setGraph(nomi,mad);
    FileWriter fr;
    try
      {
      fr=new FileWriter("cerchio.gph");
      gp.save(fr);
      fr.close();
      }
     catch (IOException ioe)
      {}
//    gp.save(new OutputStreamWriter(System.out));
    }
  }
}
