import java.awt.*;
import java.awt.event.*;
import java.io.*;

/***************
 * Crea un albero binario dato il livello dell'albero
 ***************/
public class BinaryTreeMaker extends Frame implements ActionListener
{
TextField liv;
GraphPanel gp;
/******************
 * Crea un frame in cui  inserito un GraphPanel in cui si pu rappresentare un albero binario dando il livello dell'albero.
 ******************/
public BinaryTreeMaker()
  {
  super("Binary Tree");
  liv=new TextField("indicare il livello dell'albero binario (positivo albero a fronde, negativo albero circolare)");
  liv.selectAll();
  gp=new GraphPanel();
  gp.setShowText(false);
  liv.addActionListener(this);
  setLayout(new BorderLayout());
  add(gp,BorderLayout.CENTER);
  add(liv,BorderLayout.SOUTH);
  addWindowListener(new WindowAdapter()
    {
    public void windowClosing(WindowEvent we)
      {
      dispose();
      }
    });
  pack();
  setVisible(true);
  }
/******************
 * Crea un frame in cui  inserito un GraphPanel in cui si pu rappresentare
 * un albero binario dando il livello dell'albero.
 * @param s ignorato
 ******************/
public static void main(String s[])
  {
  new BinaryTreeMaker();
  }
/******************
 * Aggiorna il GraphPanel con l'albero corrispondente e lo salva nel file binario.gph
 ******************/
public void actionPerformed(ActionEvent ae)
  {
  int livello=0;
  String nomi[];
  int mad[][];
//  System.out.println("<<"+liv+">> <<"+gp+">>");
  try
    {
    String s=liv.getText();
    liv.selectAll();
    livello=Integer.parseInt(s);
    }
   catch (NumberFormatException nfe)
    {
    }
  gp.clear();
  if (livello>0)
    {
    if (livello>9)
      {
      livello=9;
      liv.setText(""+livello);
      liv.selectAll();
      }
    int nNodi=(int)Math.pow(2,livello)-1;
    int dalt=(livello>1)?(gp.getHeight()-20)/(livello-1):1;
    int alt=10;
    int dist;
    for (int liv=0,i=0;liv<livello && i<nNodi;liv++)
      {
      int nNodiLiv=(int)Math.pow(2,liv);
//      int ddist=(gp.getWidth()-20)/nNodiLiv;
      int ddist=(gp.getWidth())/nNodiLiv;
//      System.out.println("ddist="+ddist+" ddist*nNodiLiv="+(ddist*nNodiLiv)+" width="+gp.getWidth());
//      dist=10+ddist/2;
      dist=ddist/2;
//      System.out.println("nNodi="+nNodi+" nNodiLiv="+nNodiLiv+" livello="+liv);
      for (int j=0;j<nNodiLiv;j++,i++,dist+=ddist)
        {
//        System.out.println("nodo"+i+" in "+liv+","+j+" ("+dist+","+alt+")");
        gp.addNode("nodo"+i,dist,alt);
        }
      alt+=dalt;
      }
    for (int i=0;1+i*2+1<nNodi;i++)
      {
      gp.addArc("nodo"+i,"nodo"+(1+i*2));
      gp.addArc("nodo"+i,"nodo"+(1+i*2+1));
      }
    FileWriter fr;
    try
      {
      fr=new FileWriter("binario.gph");
      gp.save(fr);
      fr.close();
      }
     catch (IOException ioe)
      {}
    }
   else if (livello<0)
    {
    if (livello<-9)
      {
      livello=-9;
      liv.setText(""+livello);
      liv.selectAll();
      }
    livello=-livello;
    int nNodi=(int)Math.pow(2,livello)-1;
    nomi=new String[nNodi];
    mad=new int[nNodi][nNodi];
    for (int i=0;i<nNodi;i++)
      {
      nomi[i]="nodo"+i;
      for (int j=0;j<nNodi;j++)
        mad[i][j]=0;
      if (1+i*2+1<nNodi)
        {
        mad[i][1+i*2]=1;
        mad[i][1+i*2+1]=1;
        }
      }
    gp.setGraph(nomi,mad);
//    System.out.println("riempito");
    FileWriter fr;
    try
      {
      fr=new FileWriter("binario.gph");
      gp.save(fr);
      fr.close();
      }
     catch (IOException ioe)
      {}
//    System.out.println("salvato");
//    gp.save(new OutputStreamWriter(System.out));
//    System.out.println("finito");
    }
  }
}
