import java.awt.*;
import java.util.Vector;

/*************
 * Il segno che rappresenta un arco 
 *
 * 19/12/2012
 *        aggiunta la visibilit dell'arco
 * 5/2/20
 *        aggiunto la possibilit di recuperare il segno dei nodi di partenza e arrivo
 * @version 2.1
 *************/
public class ArcSign<TN,TA>
{
/*************
 * L'arco rappresentato
 *************/
Arc<TN,TA> a;
/*************
 * il segno del nodo di partenza
 *************/
NodeSign<TN> from;
/*************
 * il segno del nodo di arrivo
 *************/
NodeSign<TN> to;
/*************
 * Il colore dell'arco
 *************/
Color c;
/*************
 * Lo spessore dell'arco
 *************/
int th;
/*************
 * La lunghezza preferita dell'arco
 *************/
double len;
/*************
 * La visibilit dell'arco
 *************/
boolean visible=true;
/*************
 * il successivo arco nella lista degli archi tra i due nodi
 *************/
ArcSign<TN,TA> next=null;
/*************
 * I listeners dell'arco 
 *************/
Vector <GraphListener>graphListeners=new Vector <GraphListener>();

/*************
 * Aggiunge un nuovo GraphListener all'arco.
 * @param gl il nuovo GraphListener da aggiungere
 *************/
public void addGraphListener(GraphListener gl)
  {
  graphListeners.add(gl);
  }
/*************
 * Rimuove un GraphListener dal pannello.
 * @param gl il nuovo GraphListener da aggiungere
 *************/
public void removeGraphListener(GraphListener gl)
  {
  graphListeners.removeElement(gl);
  }
 
/*************
 * Recupera i GraphListener dal pannello.
 * @return la matrice contenente i GraphListener aggiunti al pannello
 *************/
public GraphListener[] getGraphListeners()
  {
  GraphListener listeners[]=new GraphListener[graphListeners.size()];
  for (int i=0;i<graphListeners.size();i++)
    listeners[i]=graphListeners.elementAt(i);
  return listeners;
  }
/*************
 * Avverte tutti i listeners di un cambiamento dell'arco
 *************/
public void warnChanged()
  {
  for (int i=0;i<graphListeners.size();i++)  // per attivare i listeners
    graphListeners.elementAt(i).changed(new GraphEvent(this));
  }
   
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param ar l'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param c il colore dell'arco
 *************/
public ArcSign(NodeSign<TN> from,Arc<TN,TA> ar,NodeSign<TN> to,Color c)
  {
  this(from,ar,to,c,null);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param ar l'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param c il colore dell'arco
 * @param thickness lo spessore dell'arco
 * @param visible <b>true</b> se l'arco  visibile, <b>false</b> altrimenti
 *************/
public ArcSign(NodeSign<TN> from,Arc<TN,TA> ar,NodeSign<TN> to,Color c,int thickness,boolean visible)
  {
  this(from,ar,to,c,thickness,visible,null);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param ar l'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param c il colore dell'arco
 * @param next il successivo arco sovrapposto tra gli stessi nodi
 *************/
public ArcSign(NodeSign<TN> from,Arc<TN,TA> ar,NodeSign<TN> to,Color c,ArcSign<TN,TA> next)
  {
  this(from,ar,to,c,0,true,next);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param ar l'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param c il colore dell'arco
 * @param thickness lo spessore dell'arco
 * @param visible <b>true</b> se l'arco  visibile, <b>false</b> altrimenti
 * @param next il successivo arco sovrapposto tra gli stessi nodi
 *************/
public ArcSign(NodeSign<TN> from,Arc<TN,TA> ar,NodeSign<TN> to,Color c,int thickness,boolean visible,ArcSign<TN,TA> next)
  {
  a=ar;
  this.from=from;
  this.to=to;
  this.c=c;
  this.th=thickness;
  len=-1;
  this.visible=visible;
  this.next=next;
  }
/*************
 * ritorna il segno del nodo di partenza dell'arco
 * @return il segno del nodo di partenza dell'arco
 *************/
public NodeSign<TN> getFrom()
  {
  return from;
  }
/*************
 * ritorna il segno del nodo di arrivo dell'arco
 * @return il segno del nodo di arrivo dell'arco
 *************/
public NodeSign<TN> getTo()
  {
  return to;
  }
/*************
 * Ritorna l'arco rappresentato 
 * @return l'arco rappresentato
 *************/
public Arc<TN,TA> getArc()
  {
  return a;
  }
/*************
 * Calcola la lunghezza preferita dell'arco
 * @return la lunghezza preferita dell'arco
 *************/
public double getLength()
  {
  if (len<0)
    return Math.sqrt((from.getX()-to.getX())*(from.getX()-to.getX())+(from.getY()-to.getY())*(from.getY()-to.getY()));
   else
    return len;
  }
/*************
 * Stabilisce la lunghezza preferita dell'arco
 * @param length la lunghezza preferita dell'arco
 * (if less then 0 no preferred length)
 *************/
public void setPreferredLength(double length)
  {
  len=length;
  }
/*************
 * Ritorna il colore dell'arco
 * @return il colore dell'arco
 *************/
public Color getColor()
  {
  return c;
  }
/*************
 * Cambia il colore dell'arco
 * @param col il nuovo colore dell'arco
 *************/
public void setColor(Color col)
  {
  if (!col.equals(c))
    warnChanged();
  c=col;
  }
/*************
 * Ritorna lo spessore dell'arco
 * @return lo spessore dell'arco
 *************/
public int getThickness()
  {
  return th;
  }
/*************
 * Cambia lo spessore dell'arco
 * @param thick il nuovo spessore dell'arco
 *************/
public void setThickness(int thick)
  {
  if (thick!=th)
    warnChanged();
  th=thick;
  }
/*************
 * Modifica la visibilita' dell'arco
 * @param vis <b>true</b> se l'arco  visibile, <b>false</b> altrimenti
 *************/
public void setVisible(boolean vis)
  {
  if (vis!=visible)
    warnChanged();
  visible=vis;
  }
/*************
 * Ritorna la visibilita' del nodo
 * @return <b>true</b> se il nodo  visibile, <b>false</b> altrimenti
 *************/
public boolean isVisible()
  {
  return visible;
  }
/*************
* Disegna l'ArcSign 
* @param g lo spazio grafico di tracciamento
* @param dx l'offset dell'immagine
* @param dy l'offset dell'immagine
* @param z lo zoom dell'immagine
*************/
public void paint(Graphics g,int dx,int dy,double z)
  {
  paint(g,dx,dy,z,true);
  }
/*************
 * Disegna l'ArcSign 
 * @param g lo spazio grafico di tracciamento
 * @param dx l'offset dell'immagine
 * @param dy l'offset dell'immagine
 * @param z lo zoom dell'immagine
 * @param showtext true se va visualizzato i prezzi dell'arco
 *************/
public void paint(Graphics g,int dx,int dy,double z,boolean showtext)
  {
//  System.out.println(this);
  if (!visible) return;
  g.setColor(c);
  int x0=(int)((dx+from.x)*z);
  int y0=(int)((dy+from.y)*z);
  int x1=(int)((dx+to.x)*z);
  int y1=(int)((dy+to.y)*z);
  int xd0,yd0;
  int xd1,yd1;
  if (x0!=x1)
    {
    if (from.shape==NodeSign.CIRCLE)
      xd0=(int)((from.dim)*z*((x1-x0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
     else if (from.shape==NodeSign.SQUARE)
      if (y0!=y1)
        xd0=(int)((from.dim)*z*(x1-x0)/Math.abs(y1-y0));
       else
        xd0=(int)((from.dim)*z*(x1-x0)/Math.abs(x1-x0));
     else
      xd0=(int)((from.dim)*z*((x1-x0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
    if (to.shape==NodeSign.CIRCLE)
      xd1=(int)((to.dim)*z*((x1-x0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
     else if (to.shape==NodeSign.SQUARE)
      if (y0!=y1)
        xd1=(int)((to.dim)*z*(x1-x0)/Math.abs(y1-y0));
       else
        xd1=(int)((to.dim)*z*(x1-x0)/Math.abs(x1-x0));
     else
      xd1=(int)((to.dim)*z*((x1-x0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
    }
   else
    {
    xd0=0;
    xd1=0;
    }
  if (y0!=y1)
    {
    if (from.shape==NodeSign.CIRCLE)
      yd0=(int)((from.dim)*z*((y1-y0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
     else if (from.shape==NodeSign.SQUARE)
      {
      if (x0!=x1)
        {
        yd0=(int)((from.dim)*z*(y1-y0)/Math.abs(x1-x0));
        if (Math.abs(xd0)>Math.abs(yd0))
          xd0=(int)((from.dim)*z*(x1-x0)/Math.abs(x1-x0));
         else
          yd0=(int)((from.dim)*z*(y1-y0)/Math.abs(y1-y0));
        }
       else
        yd0=(int)((from.dim)*z*(y1-y0)/Math.abs(y1-y0));
      }
     else
      yd0=(int)((from.dim)*z*((y1-y0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
    if (to.shape==NodeSign.CIRCLE)
      yd1=(int)((to.dim)*z*((y1-y0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
     else if (to.shape==NodeSign.SQUARE)
      {
      if (x0!=x1)
        {
        yd1=(int)((to.dim)*z*(y1-y0)/Math.abs(x1-x0));
        if (Math.abs(xd1)>Math.abs(yd1))
          xd1=(int)((to.dim)*z*(x1-x0)/Math.abs(x1-x0));
         else
          yd1=(int)((to.dim)*z*(y1-y0)/Math.abs(y1-y0));
        }
       else
        yd1=(int)((to.dim)*z*(y1-y0)/Math.abs(y1-y0));
      }
     else
      yd1=(int)((to.dim)*z*((y1-y0)/Math.sqrt((x1-x0)*(x1-x0)+(y1-y0)*(y1-y0))));
    }
   else
    {
    yd0=0;
    yd1=0;
    }
  if (xd0!=0 || yd0!=0)
    {
    g.drawLine(x0+xd0,y0+yd0,x1-xd1,y1-yd1);
    int m=(z<1)?1:(z<2)?2:3;
    if (showtext)
      {
      int start=(int)((2*x0+3*x1)/5+th*z);  // th*m per staccarlo dalla linea
      for (ArcSign ai=this;ai!=null;ai=ai.next)
        {
        String price="";
        price+=ai.a.p;
        if (ai.next!=null)
          price+="|";
        g.setColor(ai.c);
        g.drawString(price,start,(2*y0+3*y1)/5);
        start+=g.getFontMetrics().stringWidth(price);
        }
      g.setColor(c);
      }
    if (th>0)
      {
      g.fillPolygon(new int[]{x0+xd0-yd0*th/(m+1)/10,x0+xd0+yd0*th/(m+1)/10,x1-xd1-th*(xd1/m-yd1/(m+1))/10,x1-xd1-th*(xd1/m+yd1/(m+1))/10},
                    new int[]{y0+yd0+xd0*th/(m+1)/10,y0+yd0-xd0*th/(m+1)/10,y1-yd1-th*(yd1/m+xd1/(m+1))/10,y1-yd1-th*(yd1/m-xd1/(m+1))/10},4);
      }
    }
   else
    { // anello
    xd0=0;
    yd0=(int)(-to.dim*z);
    xd1=(int)(-to.dim*z);
    yd1=0;
//    g.drawArc(x0,y0,(int)(z*2*-xd0/z),(int)(z*2*-xd0/z),90,-270);
    g.drawArc(x0,y0,(int)(z*2*-xd1/z),(int)(z*2*-xd1/z),90,-270);
    for (int thk=1;thk<z*th/2;thk++)
      {
      g.drawArc(x0-thk,y0-thk,(int)(z*2*-xd1/z+2*thk),(int)(z*2*-xd1/z+2*thk),90-thk,-270+thk);
      g.drawArc(x0+thk,y0+thk,(int)(z*2*-xd1/z-2*thk),(int)(z*2*-xd1/z-2*thk),90-thk,-270+thk);
      }
/*
    if (to.shape>2)
      {
      g.drawLine(x0-xd0,y0-yd0,x1,y1);
      g.drawLine(x0,y0,x1-xd1,y1-yd1);
      }
*/
    if (showtext)
      {
      int start=x1-xd1;  // th*m per staccarlo dalla linea
      for (ArcSign ai=this;ai!=null;ai=ai.next)
        {
        String price="";
        price+=ai.a.p;
        if (ai.next!=null)
          price+="|";
        g.setColor(ai.c);
        g.drawString(price,start,y0-yd0);
        start+=g.getFontMetrics().stringWidth(price);
        }
      g.setColor(c);
      }
/*
    if (showtext)
      g.drawString(prices,x1-xd1,y0-yd0);
*/
    }
  int m=(z<1)?1:(z<2)?2:3;
//  System.out.println(a+" "+x1+" "+y1+" "+xd1+" "+yd1+" "+m+" "+(x1-xd1)+" "+(x1-xd1-xd1/m-yd1/(m+1))+" "+(x1-xd1-xd1/m+yd1/(m+1))+" "+
//                (y1-yd1)+" "+(y1-yd1-yd1/m+xd1/(m+1))+" "+(y1-yd1-yd1/m-xd1/(m+1)));
  if (th>10)
    g.fillPolygon(new int[]{x1-xd1,x1-xd1-th*(xd1/m-yd1/(m+1))/10,x1-xd1-th*(xd1/m+yd1/(m+1))/10},
                  new int[]{y1-yd1,y1-yd1-th*(yd1/m+xd1/(m+1))/10,y1-yd1-th*(yd1/m-xd1/(m+1))/10},3);
   else
    g.fillPolygon(new int[]{x1-xd1,x1-xd1-xd1/m-yd1/(m+1),x1-xd1-xd1/m+yd1/(m+1)},
                  new int[]{y1-yd1,y1-yd1-yd1/m+xd1/(m+1),y1-yd1-yd1/m-xd1/(m+1)},3);
  }
/*************
 * Ritorna la stringa che rappresenta l'arco 
 * @return la stringa che rappresenta l'arco
 *************/
public String toString()
  {
  return "ArcSign["+from+"("+a+")"+to+","+c+"]";
  }
}
