/*************
 * Un arco di un grafo
 * 4/2/19 reso una classe generica
 * 9/2/19 associato una informazione all'arco
 * 5/2/20 inserito metodi per recuperare gli estremi dell'arco\
 *************/
public class Arc<TN,TA>
{
/*************
 * il nodo di partenza
 *************/
Node<TN> f;
/*************
 * il nodo di arrivo
 *************/
Node<TN> t;
/*************
 * il descrittore dell'arco
 *************/
TA info;
/*************
 * il peso/prezzo dell'arco
 *************/
double p;
/*************
 * il successivo arco nella lista degli archi tra i due nodi
 *************/
Arc<TN,TA> next;
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 *************/
public Arc(Node<TN> from, Node<TN> to)
  {
  this(from,to,1.0,null);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param price il prezzo/peso dell'arco da creare
 *************/
public Arc(Node<TN> from, Node<TN> to, double price)
  {
  this(from,to,price,null);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param info il descrittore dell'arco da creare
 *************/
public Arc(Node<TN> from, Node<TN> to, TA info)
  {
  this(from,to,1,info,null);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param price il prezzo/peso dell'arco da creare
 * @param next il successivo arco nella lista degli archi tra i due nodi
 *************/
public Arc(Node<TN> from, Node<TN> to, double price, Arc<TN,TA> next)
  {
  this(from,to,price,null,next);
  }
/*************
 * Crea un nuovo arco 
 * @param from il nodo di partenza dell'arco da creare
 * @param to il nodo di arrivo dell'arco da creare
 * @param price il prezzo/peso dell'arco da creare
 * @param info il descrittore dell'arco da creare
 * @param next il successivo arco nella lista degli archi tra i due nodi
 *************/
public Arc(Node<TN> from, Node<TN> to, double price,TA info, Arc<TN,TA> next)
  {
  f=from;
  t=to;
  p=price;
  this.info=info;
  this.next=next;
  }
/*************
 * Ritorna la stringa che rappresenta l'arco 
 * @return la stringa che rappresenta l'arco
 *************/
public String toString()
  {
  if (info!=null && info!=this)
    return "["+f+"("+p+"["+info+"])"+t+"]";
   else
    return "["+f+"("+p+")"+t+"]";
  }
/*************
 * Ritorna il nodo di partenza associato all'arco 
 * @return il nodo di partenza associato all'arco
 *************/
public Node<TN> getFrom()
  {
  return f;
  }
/*************
 * Ritorna il nodo di arrivo associato all'arco 
 * @return il nodo di arrivo associato all'arco
 *************/
public Node<TN> getTo()
  {
  return t;
  }
/*************
 * Ritorna il descrittore associato all'arco 
 * @return il descrittore associato all'arco
 *************/
public TA getInfo()
  {
  return info;
  }
/************
 * Associa una informazione all'arco
 * @param info l'informazione associata all'arco
 ************/
public void setInfo(TA info)
  {
  this.info=info;
  }
}

