import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class Alimentazione extends JFrame implements MouseListener//,ActionListener
{
private Container c;
private JPanel p,annotazioni,pb,contenitore,titolo,descrizione;
private JScrollPane descScroll;
private JLabel l1,tit,desc;
private JTextArea desctext;
private JTextField t;
GraphPanel gp;
String defaultName="";
double defaultWeight=1.0;
  
public Alimentazione()
  {
  super("Pesapane");
  gp= new GraphPanel();
  gp.addMouseListener(this);
  gp.setVisible(true);
  gp.setBackground(Color.green);
  gp.setNodeSize(20);
  setSize(900, 600);
  setLocation(100, 100);
  setResizable(true);
  c = getContentPane();
//   conf.addActionListener(this);
	scegli(1);
	titolo = new JPanel();
	tit=new JLabel("Alimentazione");
	tit.setSize(30,20);
	titolo.add(tit);
	
	annotazioni = new JPanel();
  l1=new JLabel("Area appunti:");
  t = new JTextField(80);
  annotazioni.add(l1);
  annotazioni.add(t);

	descrizione = new JPanel();
  descrizione.setLayout(new BorderLayout());
  desc=new JLabel("Descrizione:  ");
  desctext=new JTextArea(30,30);
  desctext.setEditable(false);
	descrizione.add(desc,BorderLayout.WEST);
  descScroll=new JScrollPane(desctext);
	descrizione.add(descScroll,BorderLayout.CENTER);

	contenitore = new JPanel();
	contenitore.setLayout(new BorderLayout());
	contenitore.add(BorderLayout.NORTH,titolo);	
  contenitore.add(BorderLayout.SOUTH,annotazioni);
  contenitore.add(BorderLayout.CENTER,gp);
	contenitore.add(BorderLayout.EAST,descrizione);
	
	c.add(contenitore);
  gp.setName(defaultName);
  gp.setWeight(defaultWeight);
  gp.setShowWeights(false);
  setVisible(true);
  setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
  }
  
  
public void scegli(int scelta)
  {
  gp.clear(false);
  switch (scelta)
    {
    case 1:
      gp.addNode("Alimentazione", 213,129);
      gp.addNode("Piramide alimentare", 94,248);
      gp.addNode("Diete", 213,283);
      gp.addNode("Calcolo peso ideale", 332,248);
      gp.addArc("Alimentazione","Piramide alimentare");
      gp.addArc("Alimentazione","Diete");
      gp.addArc("Alimentazione","Calcolo peso ideale");
      break;
    case 2:
      gp.addNode("Alimentazione",153,68 );
      gp.addNode("Piramide alimentare",107,194);
      gp.addNode("Cereali e derivati",127,358);
      gp.addNode("Frutta e verdura",178,302);
      gp.addNode("Legumi",222,249);
      gp.addNode("Latte e latticini",265,197);
      gp.addNode("Carne,pesce,uova",310,141);
      gp.addNode("Zuccheri e grassi",352,84);
      gp.addArc("Alimentazione","Piramide alimentare");
      gp.addArc("Piramide alimentare","Cereali e derivati");
      gp.addArc("Piramide alimentare","Frutta e verdura");
      gp.addArc("Piramide alimentare","Legumi");
      gp.addArc("Piramide alimentare","Latte e latticini");
      gp.addArc("Piramide alimentare","Carne,pesce,uova");
      gp.addArc("Piramide alimentare","Zuccheri e grassi");
      break;
    case 3: 
      gp.addNode("Alimentazione",198,67 );
      gp.addNode("Diete",198,185);
      gp.addNode("Dimagranti",100,294 );
      gp.addNode("Corretta Alimentazione", 294,293);
      gp.addArc("Alimentazione","Diete");
      gp.addArc("Diete","Dimagranti");
      gp.addArc("Diete","Corretta Alimentazione");
      break;
    case 4: 
      gp.addNode("Alimentazione",94,55 );
      gp.addNode("Calcolo peso ideale",205,167);
      gp.addNode("Formula Lorenz",86,275);
      gp.addNode("Formula Keys",205,301);
      gp.addNode("Formula Wan der Vael",330,275);
      gp.addArc("Alimentazione","Calcolo peso ideale");
      gp.addArc("Calcolo peso ideale","Formula Lorenz");
      gp.addArc("Calcolo peso ideale","Formula Keys");
      gp.addArc("Calcolo peso ideale","Formula Wan der Vael");					
      break;
    case 5: 
      gp.addNode("Alimentazione",327,42 );
      gp.addNode("Diete",195,118);
      gp.addNode("Dimagranti",171,221);
      gp.addNode("Dukan",83,323);
      gp.addNode("Atkins",261,323);
      gp.addArc("Alimentazione","Diete");
      gp.addArc("Diete","Dimagranti");
      gp.addArc("Dimagranti","Dukan");
      gp.addArc("Dimagranti","Atkins");					
      break;
    case 6: 
      gp.addNode("Alimentazione",121,56 );
      gp.addNode("Diete",178,116);
      gp.addNode("Corretta Alimentazione",226,193 );						
      gp.addNode("Mediterranea",135,277);
      gp.addNode("Eschimese",320,277);
      gp.addArc("Alimentazione","Diete");
      gp.addArc("Diete","Corretta Alimentazione");
      gp.addArc("Corretta Alimentazione","Mediterranea");
      gp.addArc("Corretta Alimentazione","Eschimese");
      break;
    case 7: 
      gp.addNode("Alimentazione",254,37 );
      gp.addNode("Calcolo peso ideale",254,149);
      gp.addNode("Formula Lorenz",170,240);
      gp.addNode("Calcolo Uomo con f.Lorenz",86,345);
      gp.addNode("Calcolo Donna con f.Lorenz",256,345);
      gp.addArc("Alimentazione","Calcolo peso ideale");
      gp.addArc("Calcolo peso ideale","Formula Lorenz");
      gp.addArc("Formula Lorenz","Calcolo Uomo con f.Lorenz");
      gp.addArc("Formula Lorenz","Calcolo Donna con f.Lorenz");
      break;
    case 8: 
      gp.addNode("Alimentazione",205,55 );
      gp.addNode("Calcolo peso ideale",205,161);
      gp.addNode("Formula Keys",205,254);
      gp.addNode("Calcolo Uomo con f.Keys",135,356);
      gp.addNode("Calcolo Donna con f.Keys",285,356);
      gp.addArc("Alimentazione","Calcolo peso ideale");
      gp.addArc("Calcolo peso ideale","Formula Keys");
      gp.addArc("Formula Keys","Calcolo Uomo con f.Keys");
      gp.addArc("Formula Keys","Calcolo Donna con f.Keys");
      break;							
    case 9: 
      gp.addNode("Alimentazione",83,50 );
      gp.addNode("Calcolo peso ideale",169,121);
      gp.addNode("Formula Wan der Vael",227,216);
      gp.addNode("Calcolo Uomo con f.Wan der Vael",127,323);
      gp.addNode("Calcolo Donna con f.Wan der Vael",323,323);
      gp.addArc("Alimentazione","Calcolo peso ideale");
      gp.addArc("Calcolo peso ideale","Formula Wan der Vael");
      gp.addArc("Formula Wan der Vael","Calcolo Uomo con f.Wan der Vael");
      gp.addArc("Formula Wan der Vael","Calcolo Donna con f.Wan der Vael");
      break;					
    }
  }

public boolean cambia(String temaScelto,String tema, int scelta)
  {
  if (temaScelto.equals(tema.replace(" ","_")))
    {
    desctext.setText("");
    descScroll.getViewport().setViewPosition(new Point(0,0));
    scegli(scelta);
    return true;
    }
   else
    return false;
  }

public String cut(String s, int col)
  {
  String words[]=s.split("[ \n]");
  String ris="";
  int lLinea=0;
  for (int i=0;i<words.length;i++)
    {
    if (lLinea+words[i].length()>=col)
      {
      ris+="\n"+words[i];
      lLinea=words[i].length();
      }
     else
      {
      ris+=" "+words[i];
      lLinea+=words[i].length()+1;
      }
    }
  return ris;
  }

public void mouseClicked(MouseEvent me)
  {
//  System.out.println("clickato in "+me.getX()+","+me.getY()+" "+gp.getNodeName(me.getX(), me.getY()));
  String temi[]=
    {"Alimentazione","Piramide alimentare","Diete","Calcolo peso ideale","Dimagranti",
     "Corretta Alimentazione","Formula Lorenz","Formula Keys","Formula Wan der Vael"};
  int i;
  for (i=0;i<temi.length;i++)
    if (gp.getNodeName(me.getX(), me.getY()).equals(temi[i].replace(" ","_")))
      {
      desctext.setText("");
      scegli(i+1);
      break;
      }
  if (i!=temi.length) return;
  String descriz[][]=
    {
      {"Mediterranea","La Dieta Mediterranea  linsieme delle abitudini alimentari dei popoli del bacino del Mediterraneo,\nche si sono consolidate nei secoli\ne sono rimaste pressoch immutate fino al boom economico degli anni 50.\nQuesto insieme di abitudini consiste principalmente\nnel consumo abbondante di:\nPane, Pasta, Verdure, Insalate, Legumi, Frutta, Frutta secca.\nInoltre, le caratteristiche della deita comprendono\nun consumo moderato di pesce, carne bianca, latticini e uova.\nIl consumo di carne rossa e vino  limitato rispetto alle diete di altre zone del mondo.\nPer garantire lapporto di grassi, tra i popoli del Mediterraneo,  diffuso il consumo di olio doliva,\nche contiene grassi di qualit superiore, meno nocivi di quelli animali, e anzi salutari per lorganismo.\nLa Dieta Mediterranea presenta le seguenti caratteristiche fondamentali:\nBasso contenuti di acidi grassi saturi.\nRicchezza di carboidrati e fibra.\nAlto contenuto di acidi grassi monoinsaturi derivati principalmente dallolio doliva"},
      {"Eschimese","La dieta eschimese raccomanda 2-3 porzioni di pesce grasso alla settimana,\nper ottenere molti benefci per il cuore e non solo.\nSi pu raggiungere la tua quota settimanale mangiando per esempio\nuna scatoletta di tonno a pranzo il luned,\nsalmone affumicato a cena il gioved\ne una porzione di branzino al ristorante il sabato sera."},
      {"Cereali e derivati","E' necessario assumere cereali integrali e grassi vegetali ad ogni pasto"},
      {"Frutta e verdura","Frutta e verdura devono essere consumate nell'ordine di due o tre porzioni al giorno"},
      {"Legumi","Una dieta sana prevede l'integrazione quotidiana di piccole porzioni di legumi , da una a tre volte al giorno"},
      {"Latte e latticini","Latte e latticini vanno consumati con riguardo.Non pi di 4 porzioni settimanali."},
      {"Carne,pesce,uova","Il pesce, il pollame e le uova, alternativamente, possono essere consumati per tre volte a settimana"},
      {"Zuccheri e grassi","Burro, cereali raffinati, dolci vanno consumati con moderazione e in modo alternato"},
      {"Dukan","La dieta Dukan  stata ideata dall'omonimo nutrizionista francese\nesperto di comportamento alimentare\ne si basa sull'assunzione di proteine naturali quali carne, uova e pesce.\n"+
       "Questa dieta proteica si sviluppa in 4 fasi:\n"+
       "- La Ia fase, detta anche di attacco, dura 5 giorni.\nSi mangiano unicamente proteine magre.\nQuesta fase  incentrata sulla perdita di chili da parte del corpo.\n"+
       "- Nella IIa fase, verranno assunte le stesse proteine magre della Ia fase\ncui aggiungeremo le verdure. La sua durata sar ancora di 5 giorni.\n"+
       "La Ia e la IIa fase verranno alternate fino al raggiungimento del peso desiderato.\n"+
       "- La IIIa fase  detta del consolidamento.\n abbastanza lunga e servir per ritornare progressivamente al normale consumo di cibo.\nQuando si dice normale  sottinteso che dovr essere\nun apporto completo ma equilibrato nella presenza di\ncarboidrati, proteine, verdure e frutta.\n"+
       "- La IVa fase  quella della stabilizzazione.\nDurer tutta la vita.\nSi dovr mangiare normalmente facendo per attenzione a non tornare alle errate abitudini\nche ci avevano portato sovrappeso."
       },
      {"Atkins","Il cardiologo Americano Robert C. Atkins\nide l'omonima dieta negli anni 70,\npromosse una sua dieta con benefici dimagranti e contro il colesterolo.\nLa dieta Atkins punta a mantenere costanti i livelli di insulina,\ntrasformando l'organismo in una vera e propria macchina brucia grassi.\nLimitando fortemente l'assunzione di carboidrati,\nquesta dieta costringe il corpo ad utilizzare i lipidi e le proteine come fonte energetica alternativa."},
    };
  for (i=0;i<descriz.length;i++)
    if (gp.getNodeName(me.getX(), me.getY()).equals(descriz[i][0].replace(" ","_")))
      {
      desctext.setText(cut(descriz[i][1],40));
      descScroll.getViewport().setViewPosition(new Point(0,0));
      break;
      }
  if (i!=descriz.length) return;
  String calcoli[]=
    {"Calcolo Uomo con f.Lorenz","Calcolo Donna con f.Lorenz","Calcolo Uomo con f.Keys","Calcolo Donna con f.Keys",
     "Calcolo Uomo con f.Wan der Vael","Calcolo Donna con f.Wan der Vael"};
  for (i=0;i<calcoli.length;i++)
    if (gp.getNodeName(me.getX(), me.getY()).equals(calcoli[i].replace(" ","_")))
      {
      desctext.setText("Scrivi i dati nelle caselle.");
      String s = JOptionPane.showInputDialog(this,"Digita altezza in cm:");
      if (s == null) 
        JOptionPane.showMessageDialog(null,"hai annullato");
       else
        if(s.equals(""))
          JOptionPane.showMessageDialog(null,"non hai digitato");
         else
          {
          double t= Integer.parseInt(s);
          double peso=0;
          switch (i)
            {
            case 0:
              peso=(t-100-(t-150)/4);
              break;
            case 1:
              peso=(t-100-(t-150)/2);
              break;
            case 2:
              peso=((t/100)*(t/100)*22.1);
              break;
            case 3:
              peso=(((t/100)*(t/100))*20.6);
              break;
            case 4:
              peso=((t-150)*0.75+50);
              break;
            case 5:
              peso=((t-150)*0.6+50);
              break;
            }
          JOptionPane.showMessageDialog(null,"Peso ideale:"+peso);
          }
      }
  }

public void mousePressed(MouseEvent me)
  {
  //System.out.println("pressed "+me);
  }
  
public void mouseReleased(MouseEvent me)
  {
  //System.out.println("released "+me);
  }
  
public void mouseEntered(MouseEvent me)
  {
  //System.out.println("entered "+me);
  }
  
public void mouseExited(MouseEvent me)
  {
  //System.out.println("exited "+me);
  }
  
	
public static void main(String arg[])
  {
  new Alimentazione(); 
  }
}